
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WeightUnit">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Kilo (K)"/>
 *     &lt;xs:enumeration value="Pounds (L)"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum WeightUnit implements Serializable {
    KILO_K("Kilo (K)"), POUNDS_L("Pounds (L)");
    private final String value;

    private WeightUnit(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static WeightUnit convert(String value) {
        for (WeightUnit inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
