
package com.gridnine.sabre.dqb.stl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_MealServiceType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Breakfast"/>
 *     &lt;xs:enumeration value="Snack"/>
 *     &lt;xs:enumeration value="Dinner"/>
 *     &lt;xs:enumeration value="Hot Meal"/>
 *     &lt;xs:enumeration value="Lunch"/>
 *     &lt;xs:enumeration value="Refreshments"/>
 *     &lt;xs:enumeration value="Complimentary Liquor"/>
 *     &lt;xs:enumeration value="Meal"/>
 *     &lt;xs:enumeration value="Liquor for Purchase"/>
 *     &lt;xs:enumeration value="Food for Purchase"/>
 *     &lt;xs:enumeration value="Cold Meal"/>
 *     &lt;xs:enumeration value="No Meal Service"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum _MealServiceType implements Serializable {
    /** 
     * Identifies a breakfast meal service.
     */
    BREAKFAST("Breakfast"), /** 
                             * Identifies a snack meal service.
                             */
    SNACK("Snack"), /** 
                     * Identifies a dinner meal service.
                     */
    DINNER("Dinner"), /** 
                       * Identifies a hot meal service.
                       */
    HOT_MEAL("Hot Meal"), /** 
                           * Identifies a lunch meal service.
                           */
    LUNCH("Lunch"), /** 
                     * Identifies a refreshments meal service.
                     */
    REFRESHMENTS("Refreshments"), /** 
                                   * Identifies a complimentary liquor meal service.
                                   */
    COMPLIMENTARY_LIQUOR("Complimentary Liquor"), /** 
                                                   * Identifies a meal service exists.
                                                   */
    MEAL("Meal"), /** 
                   * Identifies that liquor is available for purchase.
                   */
    LIQUORFOR_PURCHASE("Liquor for Purchase"), /** 
                                                * Identifies that food is available for purchase.
                                                */
    FOODFOR_PURCHASE("Food for Purchase"), /** 
                                            * Identifies a cold meal service is available.
                                            */
    COLD_MEAL("Cold Meal"), /** 
                             * Identifies that no meal service is available.
                             */
    NO_MEAL_SERVICE("No Meal Service");
    private final String value;

    private _MealServiceType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static _MealServiceType convert(String value) {
        for (_MealServiceType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
