
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.CodeOverShortCode;
import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Use these elements to pass the actual cash/check on hand as part of closing an accounting report.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AccountingAgentTotals">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="AgentCashAmount" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class AgentCashAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AgentCheckAmount" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class AgentCheckAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CashOverShortAmount" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class CashOverShortAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CheckOverShortAmount" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class CheckOverShortAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="overShortRemark"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _AccountingAgentTotals implements Serializable
{
    private List<AgentCashAmount> agentCashAmountList = new ArrayList<AgentCashAmount>();
    private List<AgentCheckAmount> agentCheckAmountList = new ArrayList<AgentCheckAmount>();
    private List<CashOverShortAmount> cashOverShortAmountList = new ArrayList<CashOverShortAmount>();
    private List<CheckOverShortAmount> checkOverShortAmountList = new ArrayList<CheckOverShortAmount>();
    private String overShortRemark;

    /** 
     * Get the list of 'AgentCashAmount' element items.
     * 
     * @return list
     */
    public List<AgentCashAmount> getAgentCashAmountList() {
        return agentCashAmountList;
    }

    /** 
     * Set the list of 'AgentCashAmount' element items.
     * 
     * @param list
     */
    public void setAgentCashAmountList(List<AgentCashAmount> list) {
        agentCashAmountList = list;
    }

    /** 
     * Get the list of 'AgentCheckAmount' element items.
     * 
     * @return list
     */
    public List<AgentCheckAmount> getAgentCheckAmountList() {
        return agentCheckAmountList;
    }

    /** 
     * Set the list of 'AgentCheckAmount' element items.
     * 
     * @param list
     */
    public void setAgentCheckAmountList(List<AgentCheckAmount> list) {
        agentCheckAmountList = list;
    }

    /** 
     * Get the list of 'CashOverShortAmount' element items.
     * 
     * @return list
     */
    public List<CashOverShortAmount> getCashOverShortAmountList() {
        return cashOverShortAmountList;
    }

    /** 
     * Set the list of 'CashOverShortAmount' element items.
     * 
     * @param list
     */
    public void setCashOverShortAmountList(List<CashOverShortAmount> list) {
        cashOverShortAmountList = list;
    }

    /** 
     * Get the list of 'CheckOverShortAmount' element items.
     * 
     * @return list
     */
    public List<CheckOverShortAmount> getCheckOverShortAmountList() {
        return checkOverShortAmountList;
    }

    /** 
     * Set the list of 'CheckOverShortAmount' element items.
     * 
     * @param list
     */
    public void setCheckOverShortAmountList(List<CheckOverShortAmount> list) {
        checkOverShortAmountList = list;
    }

    /** 
     * Get the 'overShortRemark' attribute value. Explanation of why over/under the expected amount.
     * 
     * @return value
     */
    public String getOverShortRemark() {
        return overShortRemark;
    }

    /** 
     * Set the 'overShortRemark' attribute value. Explanation of why over/under the expected amount.
     * 
     * @param overShortRemark
     */
    public void setOverShortRemark(String overShortRemark) {
        this.overShortRemark = overShortRemark;
    }
    /** 
     * Total cash on hand for agent closing report.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentCashAmount" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AgentCashAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * Total amount in checks on hand for agent closing report.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentCheckAmount" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AgentCheckAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * Amount of cash on hand over/under the expected amount.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CashOverShortAmount" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *         &lt;xs:attribute type="ns1:Code.OverShortCode" use="required" name="overShortCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CashOverShortAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;
        private CodeOverShortCode overShortCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'overShortCode' attribute value.
         * 
         * @return value
         */
        public CodeOverShortCode getOverShortCode() {
            return overShortCode;
        }

        /** 
         * Set the 'overShortCode' attribute value.
         * 
         * @param overShortCode
         */
        public void setOverShortCode(CodeOverShortCode overShortCode) {
            this.overShortCode = overShortCode;
        }
    }
    /** 
     * Amount of checks on hand over/under the expected amount.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckOverShortAmount" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *         &lt;xs:attribute type="ns1:Code.OverShortCode" use="required" name="overShortCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CheckOverShortAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;
        private CodeOverShortCode overShortCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'overShortCode' attribute value.
         * 
         * @return value
         */
        public CodeOverShortCode getOverShortCode() {
            return overShortCode;
        }

        /** 
         * Set the 'overShortCode' attribute value.
         * 
         * @param overShortCode
         */
        public void setOverShortCode(CodeOverShortCode overShortCode) {
            this.overShortCode = overShortCode;
        }
    }
}
