
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AccountingHeader">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IssuingAgentEprCity"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentDieSine"/>
 *     &lt;xs:element type="xs:string" name="IssueAgentEmpNum"/>
 *     &lt;xs:element type="xs:string" name="IssueCity"/>
 *     &lt;xs:element type="xs:string" name="IssueStation"/>
 *     &lt;xs:element type="xs:date" name="ReportOpenedDate"/>
 *     &lt;xs:element type="xs:dateTime" name="ReportClosedDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsReportAutoClosed"/>
 *     &lt;xs:element type="xs:string" name="ReportClosedAgentEprCity" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReportClosedAgentDieSine" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isEtPtOptionEnabled"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _AccountingHeader implements Serializable
{
    private String issuingAgentEprCity;
    private String issuingAgentDieSine;
    private String issueAgentEmpNum;
    private String issueCity;
    private String issueStation;
    private Date reportOpenedDate;
    private java.util.Date reportClosedDtm;
    private boolean isReportAutoClosed;
    private String reportClosedAgentEprCity;
    private String reportClosedAgentDieSine;
    private Boolean isEtPtOptionEnabled;

    /** 
     * Get the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @return value
     */
    public String getIssuingAgentEprCity() {
        return issuingAgentEprCity;
    }

    /** 
     * Set the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @param issuingAgentEprCity
     */
    public void setIssuingAgentEprCity(String issuingAgentEprCity) {
        this.issuingAgentEprCity = issuingAgentEprCity;
    }

    /** 
     * Get the 'IssuingAgentDieSine' element value. Die Sine of the agent issuing the documents.
     * 
     * @return value
     */
    public String getIssuingAgentDieSine() {
        return issuingAgentDieSine;
    }

    /** 
     * Set the 'IssuingAgentDieSine' element value. Die Sine of the agent issuing the documents.
     * 
     * @param issuingAgentDieSine
     */
    public void setIssuingAgentDieSine(String issuingAgentDieSine) {
        this.issuingAgentDieSine = issuingAgentDieSine;
    }

    /** 
     * Get the 'IssueAgentEmpNum' element value. Employee number of the agent issuing the document.
     * 
     * @return value
     */
    public String getIssueAgentEmpNum() {
        return issueAgentEmpNum;
    }

    /** 
     * Set the 'IssueAgentEmpNum' element value. Employee number of the agent issuing the document.
     * 
     * @param issueAgentEmpNum
     */
    public void setIssueAgentEmpNum(String issueAgentEmpNum) {
        this.issueAgentEmpNum = issueAgentEmpNum;
    }

    /** 
     * Get the 'IssueCity' element value. City Code where the documents were issued.
     * 
     * @return value
     */
    public String getIssueCity() {
        return issueCity;
    }

    /** 
     * Set the 'IssueCity' element value. City Code where the documents were issued.
     * 
     * @param issueCity
     */
    public void setIssueCity(String issueCity) {
        this.issueCity = issueCity;
    }

    /** 
     * Get the 'IssueStation' element value. Station used to issue the documents.
     * 
     * @return value
     */
    public String getIssueStation() {
        return issueStation;
    }

    /** 
     * Set the 'IssueStation' element value. Station used to issue the documents.
     * 
     * @param issueStation
     */
    public void setIssueStation(String issueStation) {
        this.issueStation = issueStation;
    }

    /** 
     * Get the 'ReportOpenedDate' element value. The date when the report was opened.
     * 
     * @return value
     */
    public Date getReportOpenedDate() {
        return reportOpenedDate;
    }

    /** 
     * Set the 'ReportOpenedDate' element value. The date when the report was opened.
     * 
     * @param reportOpenedDate
     */
    public void setReportOpenedDate(Date reportOpenedDate) {
        this.reportOpenedDate = reportOpenedDate;
    }

    /** 
     * Get the 'ReportClosedDtm' element value. The date/time when the report was closed.
     * 
     * @return value
     */
    public java.util.Date getReportClosedDtm() {
        return reportClosedDtm;
    }

    /** 
     * Set the 'ReportClosedDtm' element value. The date/time when the report was closed.
     * 
     * @param reportClosedDtm
     */
    public void setReportClosedDtm(java.util.Date reportClosedDtm) {
        this.reportClosedDtm = reportClosedDtm;
    }

    /** 
     * Get the 'IsReportAutoClosed' element value. Was this report automatically closed by the system?
     * 
     * @return value
     */
    public boolean isIsReportAutoClosed() {
        return isReportAutoClosed;
    }

    /** 
     * Set the 'IsReportAutoClosed' element value. Was this report automatically closed by the system?
     * 
     * @param isReportAutoClosed
     */
    public void setIsReportAutoClosed(boolean isReportAutoClosed) {
        this.isReportAutoClosed = isReportAutoClosed;
    }

    /** 
     * Get the 'ReportClosedAgentEprCity' element value. Home city of agent who closed the report.
     * 
     * @return value
     */
    public String getReportClosedAgentEprCity() {
        return reportClosedAgentEprCity;
    }

    /** 
     * Set the 'ReportClosedAgentEprCity' element value. Home city of agent who closed the report.
     * 
     * @param reportClosedAgentEprCity
     */
    public void setReportClosedAgentEprCity(String reportClosedAgentEprCity) {
        this.reportClosedAgentEprCity = reportClosedAgentEprCity;
    }

    /** 
     * Get the 'ReportClosedAgentDieSine' element value. Die Sine of agent who closed the report.
     * 
     * @return value
     */
    public String getReportClosedAgentDieSine() {
        return reportClosedAgentDieSine;
    }

    /** 
     * Set the 'ReportClosedAgentDieSine' element value. Die Sine of agent who closed the report.
     * 
     * @param reportClosedAgentDieSine
     */
    public void setReportClosedAgentDieSine(String reportClosedAgentDieSine) {
        this.reportClosedAgentDieSine = reportClosedAgentDieSine;
    }

    /** 
     * Get the 'isEtPtOptionEnabled' attribute value. True means this option is enabled and the ET/PT transactions are not included in the totals.
     * 
     * @return value
     */
    public Boolean getIsEtPtOptionEnabled() {
        return isEtPtOptionEnabled;
    }

    /** 
     * Set the 'isEtPtOptionEnabled' attribute value. True means this option is enabled and the ET/PT transactions are not included in the totals.
     * 
     * @param isEtPtOptionEnabled
     */
    public void setIsEtPtOptionEnabled(Boolean isEtPtOptionEnabled) {
        this.isEtPtOptionEnabled = isEtPtOptionEnabled;
    }
}
