
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_CreditCardRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:element type="ns1:_CCHeader" name="CCHeader" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_CCTransaction" name="Transaction" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_CCSummary" name="Summary" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="VendorTotalAmount" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class VendorTotalAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="GrandTotalAmount" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class GrandTotalAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _CreditCardRS implements Serializable
{
    private STLHeaderRS header;
    private _CCHeader CCHeader;
    private List<_CCTransaction> transactionList = new ArrayList<_CCTransaction>();
    private _CCSummary summary;
    private List<VendorTotalAmount> vendorTotalAmountList = new ArrayList<VendorTotalAmount>();
    private List<GrandTotalAmount> grandTotalAmountList = new ArrayList<GrandTotalAmount>();
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the 'CCHeader' element value. Describes data contained within the whole report.
     * 
     * @return value
     */
    public _CCHeader getCCHeader() {
        return CCHeader;
    }

    /** 
     * Set the 'CCHeader' element value. Describes data contained within the whole report.
     * 
     * @param CCHeader
     */
    public void setCCHeader(_CCHeader CCHeader) {
        this.CCHeader = CCHeader;
    }

    /** 
     * Get the list of 'Transaction' element items. List of transactions which match the selection criteria
     * 
     * @return list
     */
    public List<_CCTransaction> getTransactionList() {
        return transactionList;
    }

    /** 
     * Set the list of 'Transaction' element items. List of transactions which match the selection criteria
     * 
     * @param list
     */
    public void setTransactionList(List<_CCTransaction> list) {
        transactionList = list;
    }

    /** 
     * Get the 'Summary' element value. Number of issues and voided transactions included in the report
     * 
     * @return value
     */
    public _CCSummary getSummary() {
        return summary;
    }

    /** 
     * Set the 'Summary' element value. Number of issues and voided transactions included in the report
     * 
     * @param summary
     */
    public void setSummary(_CCSummary summary) {
        this.summary = summary;
    }

    /** 
     * Get the list of 'VendorTotalAmount' element items.
     * 
     * @return list
     */
    public List<VendorTotalAmount> getVendorTotalAmountList() {
        return vendorTotalAmountList;
    }

    /** 
     * Set the list of 'VendorTotalAmount' element items.
     * 
     * @param list
     */
    public void setVendorTotalAmountList(List<VendorTotalAmount> list) {
        vendorTotalAmountList = list;
    }

    /** 
     * Get the list of 'GrandTotalAmount' element items.
     * 
     * @return list
     */
    public List<GrandTotalAmount> getGrandTotalAmountList() {
        return grandTotalAmountList;
    }

    /** 
     * Set the list of 'GrandTotalAmount' element items.
     * 
     * @param list
     */
    public void setGrandTotalAmountList(List<GrandTotalAmount> list) {
        grandTotalAmountList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
    /** 
     * Total amount per credit card vendor.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorTotalAmount" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *         &lt;xs:attribute type="xs:string" use="required" name="creditCardVendor"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VendorTotalAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;
        private String creditCardVendor;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'creditCardVendor' attribute value.
         * 
         * @return value
         */
        public String getCreditCardVendor() {
            return creditCardVendor;
        }

        /** 
         * Set the 'creditCardVendor' attribute value.
         * 
         * @param creditCardVendor
         */
        public void setCreditCardVendor(String creditCardVendor) {
            this.creditCardVendor = creditCardVendor;
        }
    }
    /** 
     * Total amount per currency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GrandTotalAmount" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class GrandTotalAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
}
