
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRAssociatedDocInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AssociatedDocument" minOccurs="1" maxOccurs="6"/>
 *     &lt;xs:element type="xs:string" name="ReasonForIssuanceCode"/>
 *     &lt;xs:element type="xs:string" name="ReasonForIssuanceDesc"/>
 *     &lt;xs:element type="ns:_DRCouponDetail" name="CouponDetail" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRAssociatedDocInfo implements Serializable
{
    private List<String> associatedDocumentList = new ArrayList<String>();
    private String reasonForIssuanceCode;
    private String reasonForIssuanceDesc;
    private List<_DRCouponDetail> couponDetailList = new ArrayList<_DRCouponDetail>();

    /** 
     * Get the list of 'AssociatedDocument' element items. Document associated with compensation action.
     * 
     * @return list
     */
    public List<String> getAssociatedDocumentList() {
        return associatedDocumentList;
    }

    /** 
     * Set the list of 'AssociatedDocument' element items. Document associated with compensation action.
     * 
     * @param list
     */
    public void setAssociatedDocumentList(List<String> list) {
        associatedDocumentList = list;
    }

    /** 
     * Get the 'ReasonForIssuanceCode' element value. The ATPCO industry defined Reason for Issuance Codes (RFIC).
     * 
     * @return value
     */
    public String getReasonForIssuanceCode() {
        return reasonForIssuanceCode;
    }

    /** 
     * Set the 'ReasonForIssuanceCode' element value. The ATPCO industry defined Reason for Issuance Codes (RFIC).
     * 
     * @param reasonForIssuanceCode
     */
    public void setReasonForIssuanceCode(String reasonForIssuanceCode) {
        this.reasonForIssuanceCode = reasonForIssuanceCode;
    }

    /** 
     * Get the 'ReasonForIssuanceDesc' element value. Description of the Reason for Issuance Code (RFIC)
     * 
     * @return value
     */
    public String getReasonForIssuanceDesc() {
        return reasonForIssuanceDesc;
    }

    /** 
     * Set the 'ReasonForIssuanceDesc' element value. Description of the Reason for Issuance Code (RFIC)
     * 
     * @param reasonForIssuanceDesc
     */
    public void setReasonForIssuanceDesc(String reasonForIssuanceDesc) {
        this.reasonForIssuanceDesc = reasonForIssuanceDesc;
    }

    /** 
     * Get the list of 'CouponDetail' element items. The details associated to the coupon.
     * 
     * @return list
     */
    public List<_DRCouponDetail> getCouponDetailList() {
        return couponDetailList;
    }

    /** 
     * Set the list of 'CouponDetail' element items. The details associated to the coupon.
     * 
     * @param list
     */
    public void setCouponDetailList(List<_DRCouponDetail> list) {
        couponDetailList = list;
    }
}
