
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BaseFareAmount">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="ns1:Misc.Money">
 *             &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="NetAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class NetAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TotalAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class TotalAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="EquivalentAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class EquivalentAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="CommissionAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class CommissionAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRFareInfo implements Serializable
{
    private MiscMoney baseFareAmountMiscMoney;
    private String baseFareAmountCurrencyCode;
    private NetAmount netAmount;
    private TotalAmount totalAmount;
    private EquivalentAmount equivalentAmount;
    private CommissionAmount commissionAmount;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public MiscMoney getBaseFareAmountMiscMoney() {
        return baseFareAmountMiscMoney;
    }

    /** 
     * Set the extension value.
     * 
     * @param baseFareAmountMiscMoney
     */
    public void setBaseFareAmountMiscMoney(MiscMoney baseFareAmountMiscMoney) {
        this.baseFareAmountMiscMoney = baseFareAmountMiscMoney;
    }

    /** 
     * Get the 'currencyCode' attribute value.
     * 
     * @return value
     */
    public String getBaseFareAmountCurrencyCode() {
        return baseFareAmountCurrencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value.
     * 
     * @param baseFareAmountCurrencyCode
     */
    public void setBaseFareAmountCurrencyCode(String baseFareAmountCurrencyCode) {
        this.baseFareAmountCurrencyCode = baseFareAmountCurrencyCode;
    }

    /** 
     * Get the 'NetAmount' element value.
     * 
     * @return value
     */
    public NetAmount getNetAmount() {
        return netAmount;
    }

    /** 
     * Set the 'NetAmount' element value.
     * 
     * @param netAmount
     */
    public void setNetAmount(NetAmount netAmount) {
        this.netAmount = netAmount;
    }

    /** 
     * Get the 'TotalAmount' element value.
     * 
     * @return value
     */
    public TotalAmount getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(TotalAmount totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the 'EquivalentAmount' element value.
     * 
     * @return value
     */
    public EquivalentAmount getEquivalentAmount() {
        return equivalentAmount;
    }

    /** 
     * Set the 'EquivalentAmount' element value.
     * 
     * @param equivalentAmount
     */
    public void setEquivalentAmount(EquivalentAmount equivalentAmount) {
        this.equivalentAmount = equivalentAmount;
    }

    /** 
     * Get the 'CommissionAmount' element value.
     * 
     * @return value
     */
    public CommissionAmount getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' element value.
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(CommissionAmount commissionAmount) {
        this.commissionAmount = commissionAmount;
    }
    /** 
     * Net Remittance amount
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NetAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NetAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * Total amount including taxes
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * The equivalent amount collected in another currency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivalentAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EquivalentAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * Amount of commission paid.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *         &lt;xs:attribute type="xs:decimal" use="required" name="commissionPercent"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CommissionAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;
        private BigDecimal commissionPercent;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'commissionPercent' attribute value.
         * 
         * @return value
         */
        public BigDecimal getCommissionPercent() {
            return commissionPercent;
        }

        /** 
         * Set the 'commissionPercent' attribute value.
         * 
         * @param commissionPercent
         */
        public void setCommissionPercent(BigDecimal commissionPercent) {
            this.commissionPercent = commissionPercent;
        }
    }
}
