
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRFeeInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:Misc.Money" name="AddCollectAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="CancelPenaltyAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="OtherFeeAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_DROBFee" name="OBFeeAmount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="OBFeeTotalAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="cancelPenaltyExclusion"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRFeeInfo implements Serializable
{
    private MiscMoney addCollectAmount;
    private MiscMoney cancelPenaltyAmount;
    private MiscMoney otherFeeAmount;
    private List<_DROBFee> OBFeeAmountList = new ArrayList<_DROBFee>();
    private MiscMoney OBFeeTotalAmount;
    private String cancelPenaltyExclusion;

    /** 
     * Get the 'AddCollectAmount' element value. The amount of additional money collected.
     * 
     * @return value
     */
    public MiscMoney getAddCollectAmount() {
        return addCollectAmount;
    }

    /** 
     * Set the 'AddCollectAmount' element value. The amount of additional money collected.
     * 
     * @param addCollectAmount
     */
    public void setAddCollectAmount(MiscMoney addCollectAmount) {
        this.addCollectAmount = addCollectAmount;
    }

    /** 
     * Get the 'CancelPenaltyAmount' element value. The amount of cancellation penalties collected.
     * 
     * @return value
     */
    public MiscMoney getCancelPenaltyAmount() {
        return cancelPenaltyAmount;
    }

    /** 
     * Set the 'CancelPenaltyAmount' element value. The amount of cancellation penalties collected.
     * 
     * @param cancelPenaltyAmount
     */
    public void setCancelPenaltyAmount(MiscMoney cancelPenaltyAmount) {
        this.cancelPenaltyAmount = cancelPenaltyAmount;
    }

    /** 
     * Get the 'OtherFeeAmount' element value. The amount of all other fees collected.
     * 
     * @return value
     */
    public MiscMoney getOtherFeeAmount() {
        return otherFeeAmount;
    }

    /** 
     * Set the 'OtherFeeAmount' element value. The amount of all other fees collected.
     * 
     * @param otherFeeAmount
     */
    public void setOtherFeeAmount(MiscMoney otherFeeAmount) {
        this.otherFeeAmount = otherFeeAmount;
    }

    /** 
     * Get the list of 'OBFeeAmount' element items. The OB Fee amount.
     * 
     * @return list
     */
    public List<_DROBFee> getOBFeeAmountList() {
        return OBFeeAmountList;
    }

    /** 
     * Set the list of 'OBFeeAmount' element items. The OB Fee amount.
     * 
     * @param list
     */
    public void setOBFeeAmountList(List<_DROBFee> list) {
        OBFeeAmountList = list;
    }

    /** 
     * Get the 'OBFeeTotalAmount' element value. The total of OB Fees collected.
     * 
     * @return value
     */
    public MiscMoney getOBFeeTotalAmount() {
        return OBFeeTotalAmount;
    }

    /** 
     * Set the 'OBFeeTotalAmount' element value. The total of OB Fees collected.
     * 
     * @param OBFeeTotalAmount
     */
    public void setOBFeeTotalAmount(MiscMoney OBFeeTotalAmount) {
        this.OBFeeTotalAmount = OBFeeTotalAmount;
    }

    /** 
     * Get the 'cancelPenaltyExclusion' attribute value. Indicates whether the Cancellation Penalty was Waived or Not Applicable
     * 
     * @return value
     */
    public String getCancelPenaltyExclusion() {
        return cancelPenaltyExclusion;
    }

    /** 
     * Set the 'cancelPenaltyExclusion' attribute value. Indicates whether the Cancellation Penalty was Waived or Not Applicable
     * 
     * @param cancelPenaltyExclusion
     */
    public void setCancelPenaltyExclusion(String cancelPenaltyExclusion) {
        this.cancelPenaltyExclusion = cancelPenaltyExclusion;
    }
}
