
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRFormOfPayment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FopCode"/>
 *     &lt;xs:element type="xs:string" name="FormOfPaymentDesc"/>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="FopTotalAmount"/>
 *     &lt;xs:element type="xs:string" name="CreditCardVendor" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MaskedCCNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CreditCardExpDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CreditCardApprovalCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CreditCardExtendedPayment" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReasonForIssuance" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRFormOfPayment implements Serializable
{
    private String fopCode;
    private String formOfPaymentDesc;
    private String currencyCode;
    private MiscMoney fopTotalAmount;
    private String creditCardVendor;
    private String maskedCCNumber;
    private String creditCardExpDate;
    private String creditCardApprovalCode;
    private String creditCardExtendedPayment;
    private String reasonForIssuance;

    /** 
     * Get the 'FopCode' element value. Form of payment used to purchase this document.
     * 
     * @return value
     */
    public String getFopCode() {
        return fopCode;
    }

    /** 
     * Set the 'FopCode' element value. Form of payment used to purchase this document.
     * 
     * @param fopCode
     */
    public void setFopCode(String fopCode) {
        this.fopCode = fopCode;
    }

    /** 
     * Get the 'FormOfPaymentDesc' element value. Free form text description containing additional information about the FOP.
     * 
     * @return value
     */
    public String getFormOfPaymentDesc() {
        return formOfPaymentDesc;
    }

    /** 
     * Set the 'FormOfPaymentDesc' element value. Free form text description containing additional information about the FOP.
     * 
     * @param formOfPaymentDesc
     */
    public void setFormOfPaymentDesc(String formOfPaymentDesc) {
        this.formOfPaymentDesc = formOfPaymentDesc;
    }

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'FopTotalAmount' element value. Total money collected for this form of payment.
     * 
     * @return value
     */
    public MiscMoney getFopTotalAmount() {
        return fopTotalAmount;
    }

    /** 
     * Set the 'FopTotalAmount' element value. Total money collected for this form of payment.
     * 
     * @param fopTotalAmount
     */
    public void setFopTotalAmount(MiscMoney fopTotalAmount) {
        this.fopTotalAmount = fopTotalAmount;
    }

    /** 
     * Get the 'CreditCardVendor' element value. Vendor code if document was purchased with a credit card.
     * 
     * @return value
     */
    public String getCreditCardVendor() {
        return creditCardVendor;
    }

    /** 
     * Set the 'CreditCardVendor' element value. Vendor code if document was purchased with a credit card.
     * 
     * @param creditCardVendor
     */
    public void setCreditCardVendor(String creditCardVendor) {
        this.creditCardVendor = creditCardVendor;
    }

    /** 
     * Get the 'MaskedCCNumber' element value. Credit card number in masked format showing only partial digits.
     * 
     * @return value
     */
    public String getMaskedCCNumber() {
        return maskedCCNumber;
    }

    /** 
     * Set the 'MaskedCCNumber' element value. Credit card number in masked format showing only partial digits.
     * 
     * @param maskedCCNumber
     */
    public void setMaskedCCNumber(String maskedCCNumber) {
        this.maskedCCNumber = maskedCCNumber;
    }

    /** 
     * Get the 'CreditCardExpDate' element value. Credit card expiration date.
     * 
     * @return value
     */
    public String getCreditCardExpDate() {
        return creditCardExpDate;
    }

    /** 
     * Set the 'CreditCardExpDate' element value. Credit card expiration date.
     * 
     * @param creditCardExpDate
     */
    public void setCreditCardExpDate(String creditCardExpDate) {
        this.creditCardExpDate = creditCardExpDate;
    }

    /** 
     * Get the 'CreditCardApprovalCode' element value. Approval code returned at time of purchase.
     * 
     * @return value
     */
    public String getCreditCardApprovalCode() {
        return creditCardApprovalCode;
    }

    /** 
     * Set the 'CreditCardApprovalCode' element value. Approval code returned at time of purchase.
     * 
     * @param creditCardApprovalCode
     */
    public void setCreditCardApprovalCode(String creditCardApprovalCode) {
        this.creditCardApprovalCode = creditCardApprovalCode;
    }

    /** 
     * Get the 'CreditCardExtendedPayment' element value. Number of months to pay balance.
     * 
     * @return value
     */
    public String getCreditCardExtendedPayment() {
        return creditCardExtendedPayment;
    }

    /** 
     * Set the 'CreditCardExtendedPayment' element value. Number of months to pay balance.
     * 
     * @param creditCardExtendedPayment
     */
    public void setCreditCardExtendedPayment(String creditCardExtendedPayment) {
        this.creditCardExtendedPayment = creditCardExtendedPayment;
    }

    /** 
     * Get the 'ReasonForIssuance' element value. If EMD includes reason code for why it was issued.
     * 
     * @return value
     */
    public String getReasonForIssuance() {
        return reasonForIssuance;
    }

    /** 
     * Set the 'ReasonForIssuance' element value. If EMD includes reason code for why it was issued.
     * 
     * @param reasonForIssuance
     */
    public void setReasonForIssuance(String reasonForIssuance) {
        this.reasonForIssuance = reasonForIssuance;
    }
}
