
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRSelectionCriteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketingProvider"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isCacheLateLargeReports"/>
 *   &lt;xs:attribute type="xs:integer" name="clientTimeoutSecs"/>
 *   &lt;xs:attribute type="xs:boolean" name="isElectronicTicket"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRSelectionCriteria implements Serializable
{
    private String ticketingProvider;
    private String documentNumber;
    private Boolean isCacheLateLargeReports;
    private BigInteger clientTimeoutSecs;
    private Boolean isElectronicTicket;

    /** 
     * Get the 'TicketingProvider' element value. Carrier code the document was issued for.
     * 
     * @return value
     */
    public String getTicketingProvider() {
        return ticketingProvider;
    }

    /** 
     * Set the 'TicketingProvider' element value. Carrier code the document was issued for.
     * 
     * @param ticketingProvider
     */
    public void setTicketingProvider(String ticketingProvider) {
        this.ticketingProvider = ticketingProvider;
    }

    /** 
     * Get the 'DocumentNumber' element value. Unique identifier used to find the requested document.
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Unique identifier used to find the requested document.
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public Boolean getIsCacheLateLargeReports() {
        return isCacheLateLargeReports;
    }

    /** 
     * Set the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @param isCacheLateLargeReports
     */
    public void setIsCacheLateLargeReports(Boolean isCacheLateLargeReports) {
        this.isCacheLateLargeReports = isCacheLateLargeReports;
    }

    /** 
     * Get the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public BigInteger getClientTimeoutSecs() {
        return clientTimeoutSecs;
    }

    /** 
     * Set the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @param clientTimeoutSecs
     */
    public void setClientTimeoutSecs(BigInteger clientTimeoutSecs) {
        this.clientTimeoutSecs = clientTimeoutSecs;
    }

    /** 
     * Get the 'isElectronicTicket' attribute value. Only electronic documents will be returned.
     * 
     * @return value
     */
    public Boolean getIsElectronicTicket() {
        return isElectronicTicket;
    }

    /** 
     * Set the 'isElectronicTicket' attribute value. Only electronic documents will be returned.
     * 
     * @param isElectronicTicket
     */
    public void setIsElectronicTicket(Boolean isElectronicTicket) {
        this.isElectronicTicket = isElectronicTicket;
    }
}
