
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Details pertaining to a document. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSDocumentDetails">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentNumber"/>
 *     &lt;xs:element type="xs:string" name="LastConjunctiveDocumentNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StockType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_DSStockDetails" name="StockDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="DocumentStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TransactionCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSDocumentDetails implements Serializable
{
    private String documentNumber;
    private String lastConjunctiveDocumentNumber;
    private String stockType;
    private List<_DSStockDetails> stockDetailList = new ArrayList<_DSStockDetails>();
    private String documentStatusCode;
    private String transactionCode;

    /** 
     * Get the 'DocumentNumber' element value. The 13 digit document number. 
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. The 13 digit document number. 
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'LastConjunctiveDocumentNumber' element value. The 13 digit document number of the last conjunctive document. 
     * 
     * @return value
     */
    public String getLastConjunctiveDocumentNumber() {
        return lastConjunctiveDocumentNumber;
    }

    /** 
     * Set the 'LastConjunctiveDocumentNumber' element value. The 13 digit document number of the last conjunctive document. 
     * 
     * @param lastConjunctiveDocumentNumber
     */
    public void setLastConjunctiveDocumentNumber(
            String lastConjunctiveDocumentNumber) {
        this.lastConjunctiveDocumentNumber = lastConjunctiveDocumentNumber;
    }

    /** 
     * Get the 'StockType' element value. The stock type of the document. Ex: 1Y or AT 
     * 
     * @return value
     */
    public String getStockType() {
        return stockType;
    }

    /** 
     * Set the 'StockType' element value. The stock type of the document. Ex: 1Y or AT 
     * 
     * @param stockType
     */
    public void setStockType(String stockType) {
        this.stockType = stockType;
    }

    /** 
     * Get the list of 'StockDetails' element items.
     * 
     * @return list
     */
    public List<_DSStockDetails> getStockDetailList() {
        return stockDetailList;
    }

    /** 
     * Set the list of 'StockDetails' element items.
     * 
     * @param list
     */
    public void setStockDetailList(List<_DSStockDetails> list) {
        stockDetailList = list;
    }

    /** 
     * Get the 'DocumentStatusCode' element value. Indicates the status of the document. Ex: V (Void), N (Net remit), E (Even Exchange), A (Add Collect). This will not be populated if the document is an original issue. 
     * 
     * @return value
     */
    public String getDocumentStatusCode() {
        return documentStatusCode;
    }

    /** 
     * Set the 'DocumentStatusCode' element value. Indicates the status of the document. Ex: V (Void), N (Net remit), E (Even Exchange), A (Add Collect). This will not be populated if the document is an original issue. 
     * 
     * @param documentStatusCode
     */
    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    /** 
     * Get the 'TransactionCode' element value. The transaction code. Ex: SALE (The original sale of a document), RFND (A refunded document), CNCL (A No-Pnr Void or System Cancel) 
     * 
     * @return value
     */
    public String getTransactionCode() {
        return transactionCode;
    }

    /** 
     * Set the 'TransactionCode' element value. The transaction code. Ex: SALE (The original sale of a document), RFND (A refunded document), CNCL (A No-Pnr Void or System Cancel) 
     * 
     * @param transactionCode
     */
    public void setTransactionCode(String transactionCode) {
        this.transactionCode = transactionCode;
    }
}
