
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Information regarding a document's fees. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSFeeDetail">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FeeDetail" minOccurs="1" maxOccurs="1">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:decimal">
 *             &lt;xs:attribute type="xs:string" use="optional" name="feeType"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="cardType"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSFeeDetail implements Serializable
{
    private BigDecimal feeDetailDecimal;
    private String feeDetailFeeType;
    private String feeDetailCardType;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public BigDecimal getFeeDetailDecimal() {
        return feeDetailDecimal;
    }

    /** 
     * Set the extension value.
     * 
     * @param feeDetailDecimal
     */
    public void setFeeDetailDecimal(BigDecimal feeDetailDecimal) {
        this.feeDetailDecimal = feeDetailDecimal;
    }

    /** 
     * Get the 'feeType' attribute value. The fee type. Ex: OBF (Form of Payment Fees), OBR (Requested Services Fees), OBT (Ticketing Fees)
     * 
     * @return value
     */
    public String getFeeDetailFeeType() {
        return feeDetailFeeType;
    }

    /** 
     * Set the 'feeType' attribute value. The fee type. Ex: OBF (Form of Payment Fees), OBR (Requested Services Fees), OBT (Ticketing Fees)
     * 
     * @param feeDetailFeeType
     */
    public void setFeeDetailFeeType(String feeDetailFeeType) {
        this.feeDetailFeeType = feeDetailFeeType;
    }

    /** 
     * Get the 'cardType' attribute value. The Credit Card type that the fee belongs to. 
     * 
     * @return value
     */
    public String getFeeDetailCardType() {
        return feeDetailCardType;
    }

    /** 
     * Set the 'cardType' attribute value. The Credit Card type that the fee belongs to. 
     * 
     * @param feeDetailCardType
     */
    public void setFeeDetailCardType(String feeDetailCardType) {
        this.feeDetailCardType = feeDetailCardType;
    }
}
