
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.CodeCurrency;
import java.io.Serializable;

/** 
 * Information regarding a document's financial transactions. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSFop">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:_Code.Currency" name="CurrencyCode" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_DSPayment" name="DocumentPayment" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_DSFeeDetail" name="Fees" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSFop implements Serializable
{
    private CodeCurrency currencyCode;
    private _DSPayment documentPayment;
    private _DSFeeDetail fees;

    /** 
     * Get the 'CurrencyCode' element value. The currency code used. 
     * 
     * @return value
     */
    public CodeCurrency getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. The currency code used. 
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(CodeCurrency currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'DocumentPayment' element value. A document's payment. 
     * 
     * @return value
     */
    public _DSPayment getDocumentPayment() {
        return documentPayment;
    }

    /** 
     * Set the 'DocumentPayment' element value. A document's payment. 
     * 
     * @param documentPayment
     */
    public void setDocumentPayment(_DSPayment documentPayment) {
        this.documentPayment = documentPayment;
    }

    /** 
     * Get the 'Fees' element value. any fees associated with the payment 
     * 
     * @return value
     */
    public _DSFeeDetail getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value. any fees associated with the payment 
     * 
     * @param fees
     */
    public void setFees(_DSFeeDetail fees) {
        this.fees = fees;
    }
}
