
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;

/** 
 * Describes data for the Daily Sales Summary Report
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSHeader">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PseudoCityCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AgencyName" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSHeader implements Serializable
{
    private String pseudoCityCode;
    private String agencyName;

    /** 
     * Get the 'PseudoCityCode' element value. PCC for which the report was generated 
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' element value. PCC for which the report was generated 
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'AgencyName' element value. Agency name for which the report is generated 
     * 
     * @return value
     */
    public String getAgencyName() {
        return agencyName;
    }

    /** 
     * Set the 'AgencyName' element value. Agency name for which the report is generated 
     * 
     * @param agencyName
     */
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }
}
