
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * The response generated for a Daily Sales Summary Request. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSReport">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="ReportDate" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_DSTransaction" name="Transaction" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:_DSTotalDailySales" name="TotalDailySales" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSReport implements Serializable
{
    private Date reportDate;
    private List<_DSTransaction> transactionList = new ArrayList<_DSTransaction>();
    private List<_DSTotalDailySales> totalDailySaleList = new ArrayList<_DSTotalDailySales>();

    /** 
     * Get the 'ReportDate' element value. Date the report was generated for (It will mactch the request date if it was specified, or will be the current date if its not specified in request)
     * 
     * @return value
     */
    public Date getReportDate() {
        return reportDate;
    }

    /** 
     * Set the 'ReportDate' element value. Date the report was generated for (It will mactch the request date if it was specified, or will be the current date if its not specified in request)
     * 
     * @param reportDate
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /** 
     * Get the list of 'Transaction' element items. Daily Sales Summary details about the document
     * 
     * @return list
     */
    public List<_DSTransaction> getTransactionList() {
        return transactionList;
    }

    /** 
     * Set the list of 'Transaction' element items. Daily Sales Summary details about the document
     * 
     * @param list
     */
    public void setTransactionList(List<_DSTransaction> list) {
        transactionList = list;
    }

    /** 
     * Get the list of 'TotalDailySales' element items. Summary of Totals based on Transaction, Settlement and payment type
     * 
     * @return list
     */
    public List<_DSTotalDailySales> getTotalDailySaleList() {
        return totalDailySaleList;
    }

    /** 
     * Set the list of 'TotalDailySales' element items. Summary of Totals based on Transaction, Settlement and payment type
     * 
     * @param list
     */
    public void setTotalDailySaleList(List<_DSTotalDailySales> list) {
        totalDailySaleList = list;
    }
}
