
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Total sales by settlement type. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSTotalDailySalesBySettlementType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="SettlementType"/>
 *     &lt;xs:element type="ns:_DSTotalDailySalesByCurrency" name="SaleTotals" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSTotalDailySalesBySettlementType implements Serializable
{
    private String settlementType;
    private List<_DSTotalDailySalesByCurrency> saleTotalList = new ArrayList<_DSTotalDailySalesByCurrency>();

    /** 
     * Get the 'SettlementType' element value. The Settlement type of the totals. Ex: TAT, TCH, TKT 
     * 
     * @return value
     */
    public String getSettlementType() {
        return settlementType;
    }

    /** 
     * Set the 'SettlementType' element value. The Settlement type of the totals. Ex: TAT, TCH, TKT 
     * 
     * @param settlementType
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /** 
     * Get the list of 'SaleTotals' element items. Totals for all transactions for a currency 
     * 
     * @return list
     */
    public List<_DSTotalDailySalesByCurrency> getSaleTotalList() {
        return saleTotalList;
    }

    /** 
     * Set the list of 'SaleTotals' element items. Totals for all transactions for a currency 
     * 
     * @param list
     */
    public void setSaleTotalList(List<_DSTotalDailySalesByCurrency> list) {
        saleTotalList = list;
    }
}
