
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * List of documents which match the selection criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSTransaction">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentType"/>
 *     &lt;xs:element type="xs:string" name="SettlementType" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PnrLocator" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
 *     &lt;xs:element type="ns:_DSDocumentDetails" name="DocumentDetails" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_AirlineCode" name="AirlineCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_Commision" name="Commission" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_DSFop" name="Payments" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="AgentSine"/>
 *     &lt;xs:element type="xs:string" name="AgentPseudoCity" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="TransactionDateTime"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="nonInteractive"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="electronicDocument"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="itineraryType"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="automatedRefund"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSTransaction implements Serializable
{
    private String documentType;
    private String settlementType;
    private String pnrLocator;
    private String passengerName;
    private _DSDocumentDetails documentDetails;
    private _AirlineCode airlineCode;
    private _Commision commission;
    private List<_DSFop> paymentList = new ArrayList<_DSFop>();
    private String agentSine;
    private String agentPseudoCity;
    private Date transactionDateTime;
    private Boolean nonInteractive;
    private Boolean electronicDocument;
    private String itineraryType;
    private Boolean automatedRefund;

    /** 
     * Get the 'DocumentType' element value. The document type. Ex: TKT, EMD,RFD, RFEMD, MCO. 
     * 
     * @return value
     */
    public String getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. The document type. Ex: TKT, EMD,RFD, RFEMD, MCO. 
     * 
     * @param documentType
     */
    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'SettlementType' element value. The settlement type of the document. Ex: TAT, TCH, TKT, STA or KIL. 
     * 
     * @return value
     */
    public String getSettlementType() {
        return settlementType;
    }

    /** 
     * Set the 'SettlementType' element value. The settlement type of the document. Ex: TAT, TCH, TKT, STA or KIL. 
     * 
     * @param settlementType
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /** 
     * Get the 'PnrLocator' element value. The Pnr the document belongs to. 
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'PnrLocator' element value. The Pnr the document belongs to. 
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }

    /** 
     * Get the 'PassengerName' element value. The full name of the passenger. 
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. The full name of the passenger. 
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'DocumentDetails' element value. Details regarding the document 
     * 
     * @return value
     */
    public _DSDocumentDetails getDocumentDetails() {
        return documentDetails;
    }

    /** 
     * Set the 'DocumentDetails' element value. Details regarding the document 
     * 
     * @param documentDetails
     */
    public void setDocumentDetails(_DSDocumentDetails documentDetails) {
        this.documentDetails = documentDetails;
    }

    /** 
     * Get the 'AirlineCode' element value. Arline char code and number code 
     * 
     * @return value
     */
    public _AirlineCode getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value. Arline char code and number code 
     * 
     * @param airlineCode
     */
    public void setAirlineCode(_AirlineCode airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'Commission' element value. Commission collected for the document 
     * 
     * @return value
     */
    public _Commision getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. Commission collected for the document 
     * 
     * @param commission
     */
    public void setCommission(_Commision commission) {
        this.commission = commission;
    }

    /** 
     * Get the list of 'Payments' element items. Payment information 
     * 
     * @return list
     */
    public List<_DSFop> getPaymentList() {
        return paymentList;
    }

    /** 
     * Set the list of 'Payments' element items. Payment information 
     * 
     * @param list
     */
    public void setPaymentList(List<_DSFop> list) {
        paymentList = list;
    }

    /** 
     * Get the 'AgentSine' element value. The identifying code for the agent performing the transaction. Ex: AGT 
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' element value. The identifying code for the agent performing the transaction. Ex: AGT 
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'AgentPseudoCity' element value. The Psuedo City that the Agent performing the transaction belongs to. 
     * 
     * @return value
     */
    public String getAgentPseudoCity() {
        return agentPseudoCity;
    }

    /** 
     * Set the 'AgentPseudoCity' element value. The Psuedo City that the Agent performing the transaction belongs to. 
     * 
     * @param agentPseudoCity
     */
    public void setAgentPseudoCity(String agentPseudoCity) {
        this.agentPseudoCity = agentPseudoCity;
    }

    /** 
     * Get the 'TransactionDateTime' element value. The date time of this transaction. 
     * 
     * @return value
     */
    public Date getTransactionDateTime() {
        return transactionDateTime;
    }

    /** 
     * Set the 'TransactionDateTime' element value. The date time of this transaction. 
     * 
     * @param transactionDateTime
     */
    public void setTransactionDateTime(Date transactionDateTime) {
        this.transactionDateTime = transactionDateTime;
    }

    /** 
     * Get the 'nonInteractive' attribute value. Indicates if the document was issued non interactive. 
     * 
     * @return value
     */
    public Boolean getNonInteractive() {
        return nonInteractive;
    }

    /** 
     * Set the 'nonInteractive' attribute value. Indicates if the document was issued non interactive. 
     * 
     * @param nonInteractive
     */
    public void setNonInteractive(Boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    /** 
     * Get the 'electronicDocument' attribute value. Indicates if the document is an electronic document or not. 
     * 
     * @return value
     */
    public Boolean getElectronicDocument() {
        return electronicDocument;
    }

    /** 
     * Set the 'electronicDocument' attribute value. Indicates if the document is an electronic document or not. 
     * 
     * @param electronicDocument
     */
    public void setElectronicDocument(Boolean electronicDocument) {
        this.electronicDocument = electronicDocument;
    }

    /** 
     * Get the 'itineraryType' attribute value. Indicates if the document for Domestic(D) or Internation(I) travel 
     * 
     * @return value
     */
    public String getItineraryType() {
        return itineraryType;
    }

    /** 
     * Set the 'itineraryType' attribute value. Indicates if the document for Domestic(D) or Internation(I) travel 
     * 
     * @param itineraryType
     */
    public void setItineraryType(String itineraryType) {
        this.itineraryType = itineraryType;
    }

    /** 
     * Get the 'automatedRefund' attribute value. Indicates if the document was issued through automated refunds or not. 
     * 
     * @return value
     */
    public Boolean getAutomatedRefund() {
        return automatedRefund;
    }

    /** 
     * Set the 'automatedRefund' attribute value. Indicates if the document was issued through automated refunds or not. 
     * 
     * @param automatedRefund
     */
    public void setAutomatedRefund(Boolean automatedRefund) {
        this.automatedRefund = automatedRefund;
    }
}
