
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Used to define what should be included in the Daily Sales Summary report including optional filters. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DailySSSelectionCriteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PseudoCityCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_AirlineChoice" name="Airline" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="ReportDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SettlementType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DocumentType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isCacheLateLargeReports"/>
 *   &lt;xs:attribute type="xs:integer" name="clientTimeoutSecs"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DailySSSelectionCriteria implements Serializable
{
    private String pseudoCityCode;
    private _AirlineChoice airline;
    private Date reportDate;
    private String settlementType;
    private String documentType;
    private String documentNumber;
    private Boolean isCacheLateLargeReports;
    private BigInteger clientTimeoutSecs;

    /** 
     * Get the 'PseudoCityCode' element value. Report data will be limited to data for this Psuedo City. This is a four digit code. 
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' element value. Report data will be limited to data for this Psuedo City. This is a four digit code. 
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'Airline' element value. Arline char code and number code 
     * 
     * @return value
     */
    public _AirlineChoice getAirline() {
        return airline;
    }

    /** 
     * Set the 'Airline' element value. Arline char code and number code 
     * 
     * @param airline
     */
    public void setAirline(_AirlineChoice airline) {
        this.airline = airline;
    }

    /** 
     * Get the 'ReportDate' element value. Report data will be limited to this date. 
     * 
     * @return value
     */
    public Date getReportDate() {
        return reportDate;
    }

    /** 
     * Set the 'ReportDate' element value. Report data will be limited to this date. 
     * 
     * @param reportDate
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /** 
     * Get the 'SettlementType' element value. Report data will be limited to the settlement type specified. Available options for this are: TAT, TCH,TKT,STA, or KIL 
     * 
     * @return value
     */
    public String getSettlementType() {
        return settlementType;
    }

    /** 
     * Set the 'SettlementType' element value. Report data will be limited to the settlement type specified. Available options for this are: TAT, TCH,TKT,STA, or KIL 
     * 
     * @param settlementType
     */
    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /** 
     * Get the 'DocumentType' element value. Report data will be limited to the report type specified. Available options for this are: TKT,EMD,RFND,RFEMD,MCO,ALL. 
     * 
     * @return value
     */
    public String getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. Report data will be limited to the report type specified. Available options for this are: TKT,EMD,RFND,RFEMD,MCO,ALL. 
     * 
     * @param documentType
     */
    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'DocumentNumber' element value. The 13 digit document number. 
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. The 13 digit document number. 
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public Boolean getIsCacheLateLargeReports() {
        return isCacheLateLargeReports;
    }

    /** 
     * Set the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @param isCacheLateLargeReports
     */
    public void setIsCacheLateLargeReports(Boolean isCacheLateLargeReports) {
        this.isCacheLateLargeReports = isCacheLateLargeReports;
    }

    /** 
     * Get the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public BigInteger getClientTimeoutSecs() {
        return clientTimeoutSecs;
    }

    /** 
     * Set the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @param clientTimeoutSecs
     */
    public void setClientTimeoutSecs(BigInteger clientTimeoutSecs) {
        this.clientTimeoutSecs = clientTimeoutSecs;
    }
}
