
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DetailRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:element type="ns1:_DRHeader" name="DetailHeader" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRAssociatedDocInfo" name="AssociatedDocInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRRefundLine" name="RefundLine" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRFormOfPayment" name="FormOfPayment" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_DRCouponDetail" name="CouponDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_DRItemDetail" name="ItemDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="FareCalcLine" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRFareInfo" name="FareInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="Remark" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Remark -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:_DRCostInfo" name="CostInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRPtaInfo" name="PrepaidTktAdviceInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRTaxInfo" name="TaxInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_DRExchangeInfo" name="ExchangeInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DRFeeInfo" name="FeeInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IssuedInConnectionDocNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DetailRS implements Serializable
{
    private STLHeaderRS header;
    private _DRHeader detailHeader;
    private _DRAssociatedDocInfo associatedDocInfo;
    private _DRRefundLine refundLine;
    private List<_DRFormOfPayment> formOfPaymentList = new ArrayList<_DRFormOfPayment>();
    private List<_DRCouponDetail> couponDetailList = new ArrayList<_DRCouponDetail>();
    private List<_DRItemDetail> itemDetailList = new ArrayList<_DRItemDetail>();
    private String fareCalcLine;
    private _DRFareInfo fareInfo;
    private List<Remark> remarkList = new ArrayList<Remark>();
    private _DRCostInfo costInfo;
    private _DRPtaInfo prepaidTktAdviceInfo;
    private List<_DRTaxInfo> taxInfoList = new ArrayList<_DRTaxInfo>();
    private _DRExchangeInfo exchangeInfo;
    private _DRFeeInfo feeInfo;
    private String issuedInConnectionDocNumber;
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the 'DetailHeader' element value. Contains the header information for Detail Report
     * 
     * @return value
     */
    public _DRHeader getDetailHeader() {
        return detailHeader;
    }

    /** 
     * Set the 'DetailHeader' element value. Contains the header information for Detail Report
     * 
     * @param detailHeader
     */
    public void setDetailHeader(_DRHeader detailHeader) {
        this.detailHeader = detailHeader;
    }

    /** 
     * Get the 'AssociatedDocInfo' element value. Contains all the elements for a document associated with a compensation action.
     * 
     * @return value
     */
    public _DRAssociatedDocInfo getAssociatedDocInfo() {
        return associatedDocInfo;
    }

    /** 
     * Set the 'AssociatedDocInfo' element value. Contains all the elements for a document associated with a compensation action.
     * 
     * @param associatedDocInfo
     */
    public void setAssociatedDocInfo(_DRAssociatedDocInfo associatedDocInfo) {
        this.associatedDocInfo = associatedDocInfo;
    }

    /** 
     * Get the 'RefundLine' element value. Contains all the elements associated with a refund transaction.
     * 
     * @return value
     */
    public _DRRefundLine getRefundLine() {
        return refundLine;
    }

    /** 
     * Set the 'RefundLine' element value. Contains all the elements associated with a refund transaction.
     * 
     * @param refundLine
     */
    public void setRefundLine(_DRRefundLine refundLine) {
        this.refundLine = refundLine;
    }

    /** 
     * Get the list of 'FormOfPayment' element items. Contains all the elements for a form of payment used in a transaction.
     * 
     * @return list
     */
    public List<_DRFormOfPayment> getFormOfPaymentList() {
        return formOfPaymentList;
    }

    /** 
     * Set the list of 'FormOfPayment' element items. Contains all the elements for a form of payment used in a transaction.
     * 
     * @param list
     */
    public void setFormOfPaymentList(List<_DRFormOfPayment> list) {
        formOfPaymentList = list;
    }

    /** 
     * Get the list of 'CouponDetail' element items. Contains all the elements associated to a coupon.
     * 
     * @return list
     */
    public List<_DRCouponDetail> getCouponDetailList() {
        return couponDetailList;
    }

    /** 
     * Set the list of 'CouponDetail' element items. Contains all the elements associated to a coupon.
     * 
     * @param list
     */
    public void setCouponDetailList(List<_DRCouponDetail> list) {
        couponDetailList = list;
    }

    /** 
     * Get the list of 'ItemDetail' element items. Contains all the elements associated to an EMD item.
     * 
     * @return list
     */
    public List<_DRItemDetail> getItemDetailList() {
        return itemDetailList;
    }

    /** 
     * Set the list of 'ItemDetail' element items. Contains all the elements associated to an EMD item.
     * 
     * @param list
     */
    public void setItemDetailList(List<_DRItemDetail> list) {
        itemDetailList = list;
    }

    /** 
     * Get the 'FareCalcLine' element value. Contains all the elements in a fare calculation line of a travel document.
     * 
     * @return value
     */
    public String getFareCalcLine() {
        return fareCalcLine;
    }

    /** 
     * Set the 'FareCalcLine' element value. Contains all the elements in a fare calculation line of a travel document.
     * 
     * @param fareCalcLine
     */
    public void setFareCalcLine(String fareCalcLine) {
        this.fareCalcLine = fareCalcLine;
    }

    /** 
     * Get the 'FareInfo' element value. Contains all the elements associated to the fare of a travel document.
     * 
     * @return value
     */
    public _DRFareInfo getFareInfo() {
        return fareInfo;
    }

    /** 
     * Set the 'FareInfo' element value. Contains all the elements associated to the fare of a travel document.
     * 
     * @param fareInfo
     */
    public void setFareInfo(_DRFareInfo fareInfo) {
        this.fareInfo = fareInfo;
    }

    /** 
     * Get the list of 'Remark' element items.
     * 
     * @return list
     */
    public List<Remark> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items.
     * 
     * @param list
     */
    public void setRemarkList(List<Remark> list) {
        remarkList = list;
    }

    /** 
     * Get the 'CostInfo' element value. Contains the elements associated to the cost of the transaction (base amount).
     * 
     * @return value
     */
    public _DRCostInfo getCostInfo() {
        return costInfo;
    }

    /** 
     * Set the 'CostInfo' element value. Contains the elements associated to the cost of the transaction (base amount).
     * 
     * @param costInfo
     */
    public void setCostInfo(_DRCostInfo costInfo) {
        this.costInfo = costInfo;
    }

    /** 
     * Get the 'PrepaidTktAdviceInfo' element value. Contains the elements associated with a pre-Paid Ticket Advice.
     * 
     * @return value
     */
    public _DRPtaInfo getPrepaidTktAdviceInfo() {
        return prepaidTktAdviceInfo;
    }

    /** 
     * Set the 'PrepaidTktAdviceInfo' element value. Contains the elements associated with a pre-Paid Ticket Advice.
     * 
     * @param prepaidTktAdviceInfo
     */
    public void setPrepaidTktAdviceInfo(_DRPtaInfo prepaidTktAdviceInfo) {
        this.prepaidTktAdviceInfo = prepaidTktAdviceInfo;
    }

    /** 
     * Get the list of 'TaxInfo' element items. Contains the elements associated with the tax information collected as noted on a travel document.
     * 
     * @return list
     */
    public List<_DRTaxInfo> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. Contains the elements associated with the tax information collected as noted on a travel document.
     * 
     * @param list
     */
    public void setTaxInfoList(List<_DRTaxInfo> list) {
        taxInfoList = list;
    }

    /** 
     * Get the 'ExchangeInfo' element value. Contains all the elements associated with an exchange transaction.
     * 
     * @return value
     */
    public _DRExchangeInfo getExchangeInfo() {
        return exchangeInfo;
    }

    /** 
     * Set the 'ExchangeInfo' element value. Contains all the elements associated with an exchange transaction.
     * 
     * @param exchangeInfo
     */
    public void setExchangeInfo(_DRExchangeInfo exchangeInfo) {
        this.exchangeInfo = exchangeInfo;
    }

    /** 
     * Get the 'FeeInfo' element value. Contains all the elements associated with fees collected as noted on travel document.
     * 
     * @return value
     */
    public _DRFeeInfo getFeeInfo() {
        return feeInfo;
    }

    /** 
     * Set the 'FeeInfo' element value. Contains all the elements associated with fees collected as noted on travel document.
     * 
     * @param feeInfo
     */
    public void setFeeInfo(_DRFeeInfo feeInfo) {
        this.feeInfo = feeInfo;
    }

    /** 
     * Get the 'IssuedInConnectionDocNumber' element value. Document issued in connection with another action.
     * 
     * @return value
     */
    public String getIssuedInConnectionDocNumber() {
        return issuedInConnectionDocNumber;
    }

    /** 
     * Set the 'IssuedInConnectionDocNumber' element value. Document issued in connection with another action.
     * 
     * @param issuedInConnectionDocNumber
     */
    public void setIssuedInConnectionDocNumber(
            String issuedInConnectionDocNumber) {
        this.issuedInConnectionDocNumber = issuedInConnectionDocNumber;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
    /** 
     * Remarks. Free Text.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="required" name="remarkType"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String string;
        private String remarkType;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'remarkType' attribute value.
         * 
         * @return value
         */
        public String getRemarkType() {
            return remarkType;
        }

        /** 
         * Set the 'remarkType' attribute value.
         * 
         * @param remarkType
         */
        public void setRemarkType(String remarkType) {
            this.remarkType = remarkType;
        }
    }
}
