
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_SSTotalDailySales">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element name="SubTotal" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class SubTotal -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _SSTotalDailySales implements Serializable
{
    private String currencyCode;
    private List<SubTotal> subTotalList = new ArrayList<SubTotal>();

    /** 
     * Get the 'CurrencyCode' element value. Currency of the total money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the total money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the list of 'SubTotal' element items.
     * 
     * @return list
     */
    public List<SubTotal> getSubTotalList() {
        return subTotalList;
    }

    /** 
     * Set the list of 'SubTotal' element items.
     * 
     * @param list
     */
    public void setSubTotalList(List<SubTotal> list) {
        subTotalList = list;
    }
    /** 
     * Total money collected per form of payment. one SubTotal element per fop.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SubTotal" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="fop"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SubTotal implements Serializable
    {
        private MiscMoney miscMoney;
        private String fop;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'fop' attribute value.
         * 
         * @return value
         */
        public String getFop() {
            return fop;
        }

        /** 
         * Set the 'fop' attribute value.
         * 
         * @param fop
         */
        public void setFop(String fop) {
            this.fop = fop;
        }
    }
}
