
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaMgrSelectionCriteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketingProvider"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="StationNumber"/>
 *       &lt;xs:element type="xs:string" name="IssuingCityCode"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:date" name="ReportDate"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isCacheLateLargeReports"/>
 *   &lt;xs:attribute type="xs:integer" name="clientTimeoutSecs"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaMgrSelectionCriteria implements Serializable
{
    private String ticketingProvider;
    private int choiceSelect = -1;
    private static final int STATION_NUMBER_CHOICE = 0;
    private static final int ISSUING_CITY_CODE_CHOICE = 1;
    private String stationNumber;
    private String issuingCityCode;
    private Date reportDate;
    private Boolean isCacheLateLargeReports;
    private BigInteger clientTimeoutSecs;

    /** 
     * Get the 'TicketingProvider' element value. Carrier to pull data from.
     * 
     * @return value
     */
    public String getTicketingProvider() {
        return ticketingProvider;
    }

    /** 
     * Set the 'TicketingProvider' element value. Carrier to pull data from.
     * 
     * @param ticketingProvider
     */
    public void setTicketingProvider(String ticketingProvider) {
        this.ticketingProvider = ticketingProvider;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if StationNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifStationNumber() {
        return choiceSelect == STATION_NUMBER_CHOICE;
    }

    /** 
     * Get the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        setChoiceSelect(STATION_NUMBER_CHOICE);
        this.stationNumber = stationNumber;
    }

    /** 
     * Check if IssuingCityCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifIssuingCityCode() {
        return choiceSelect == ISSUING_CITY_CODE_CHOICE;
    }

    /** 
     * Get the 'IssuingCityCode' element value. The city code where the agent issued a document. 
     * 
     * @return value
     */
    public String getIssuingCityCode() {
        return issuingCityCode;
    }

    /** 
     * Set the 'IssuingCityCode' element value. The city code where the agent issued a document. 
     * 
     * @param issuingCityCode
     */
    public void setIssuingCityCode(String issuingCityCode) {
        setChoiceSelect(ISSUING_CITY_CODE_CHOICE);
        this.issuingCityCode = issuingCityCode;
    }

    /** 
     * Get the 'ReportDate' element value. Report data will be limited to this date.  Each report can only contain data for one day.
     * 
     * @return value
     */
    public Date getReportDate() {
        return reportDate;
    }

    /** 
     * Set the 'ReportDate' element value. Report data will be limited to this date.  Each report can only contain data for one day.
     * 
     * @param reportDate
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /** 
     * Get the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public Boolean getIsCacheLateLargeReports() {
        return isCacheLateLargeReports;
    }

    /** 
     * Set the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @param isCacheLateLargeReports
     */
    public void setIsCacheLateLargeReports(Boolean isCacheLateLargeReports) {
        this.isCacheLateLargeReports = isCacheLateLargeReports;
    }

    /** 
     * Get the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public BigInteger getClientTimeoutSecs() {
        return clientTimeoutSecs;
    }

    /** 
     * Set the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @param clientTimeoutSecs
     */
    public void setClientTimeoutSecs(BigInteger clientTimeoutSecs) {
        this.clientTimeoutSecs = clientTimeoutSecs;
    }
}
