
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaMgrStationTotal">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IssuingCityCode"/>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="CommissionAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="StationRevenue" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="Voids" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="NumExceptionItems" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="Vouchers" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class Vouchers -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="PrepaidAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class PrepaidAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ExchangeAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class ExchangeAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:Misc.Money" name="IgnoredResidualValue" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="EvenExchangeShortage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="EvenExchangeOverage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="DocTypeAmount" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class DocTypeAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaMgrStationTotal implements Serializable
{
    private String issuingCityCode;
    private String stationNumber;
    private String currencyCode;
    private MiscMoney commissionAmount;
    private MiscMoney stationRevenue;
    private BigInteger voids;
    private BigInteger numExceptionItems;
    private Vouchers vouchers;
    private PrepaidAmount prepaidAmount;
    private ExchangeAmount exchangeAmount;
    private MiscMoney ignoredResidualValue;
    private MiscMoney evenExchangeShortage;
    private MiscMoney evenExchangeOverage;
    private List<DocTypeAmount> docTypeAmountList = new ArrayList<DocTypeAmount>();

    /** 
     * Get the 'IssuingCityCode' element value. The city code where the agent issued a document. 
     * 
     * @return value
     */
    public String getIssuingCityCode() {
        return issuingCityCode;
    }

    /** 
     * Set the 'IssuingCityCode' element value. The city code where the agent issued a document. 
     * 
     * @param issuingCityCode
     */
    public void setIssuingCityCode(String issuingCityCode) {
        this.issuingCityCode = issuingCityCode;
    }

    /** 
     * Get the 'StationNumber' element value. Unique identifier for the station.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Unique identifier for the station.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'CommissionAmount' element value. Total amount of commission.
     * 
     * @return value
     */
    public MiscMoney getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' element value. Total amount of commission.
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(MiscMoney commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /** 
     * Get the 'StationRevenue' element value. Total amount of monies collected by the station.
     * 
     * @return value
     */
    public MiscMoney getStationRevenue() {
        return stationRevenue;
    }

    /** 
     * Set the 'StationRevenue' element value. Total amount of monies collected by the station.
     * 
     * @param stationRevenue
     */
    public void setStationRevenue(MiscMoney stationRevenue) {
        this.stationRevenue = stationRevenue;
    }

    /** 
     * Get the 'Voids' element value. Total number of Voided transactions.
     * 
     * @return value
     */
    public BigInteger getVoids() {
        return voids;
    }

    /** 
     * Set the 'Voids' element value. Total number of Voided transactions.
     * 
     * @param voids
     */
    public void setVoids(BigInteger voids) {
        this.voids = voids;
    }

    /** 
     * Get the 'NumExceptionItems' element value. Total number of Exception transactions.
     * 
     * @return value
     */
    public BigInteger getNumExceptionItems() {
        return numExceptionItems;
    }

    /** 
     * Set the 'NumExceptionItems' element value. Total number of Exception transactions.
     * 
     * @param numExceptionItems
     */
    public void setNumExceptionItems(BigInteger numExceptionItems) {
        this.numExceptionItems = numExceptionItems;
    }

    /** 
     * Get the 'Vouchers' element value.
     * 
     * @return value
     */
    public Vouchers getVouchers() {
        return vouchers;
    }

    /** 
     * Set the 'Vouchers' element value.
     * 
     * @param vouchers
     */
    public void setVouchers(Vouchers vouchers) {
        this.vouchers = vouchers;
    }

    /** 
     * Get the 'PrepaidAmount' element value.
     * 
     * @return value
     */
    public PrepaidAmount getPrepaidAmount() {
        return prepaidAmount;
    }

    /** 
     * Set the 'PrepaidAmount' element value.
     * 
     * @param prepaidAmount
     */
    public void setPrepaidAmount(PrepaidAmount prepaidAmount) {
        this.prepaidAmount = prepaidAmount;
    }

    /** 
     * Get the 'ExchangeAmount' element value.
     * 
     * @return value
     */
    public ExchangeAmount getExchangeAmount() {
        return exchangeAmount;
    }

    /** 
     * Set the 'ExchangeAmount' element value.
     * 
     * @param exchangeAmount
     */
    public void setExchangeAmount(ExchangeAmount exchangeAmount) {
        this.exchangeAmount = exchangeAmount;
    }

    /** 
     * Get the 'IgnoredResidualValue' element value. This functionality requires activation and is controlled by settings in the Ticketing Options Table (maintained by Sabre) and CAT31 fare filings. When active, the system does not include a residual value from an exchange document in the grand total of the report.
     * 
     * @return value
     */
    public MiscMoney getIgnoredResidualValue() {
        return ignoredResidualValue;
    }

    /** 
     * Set the 'IgnoredResidualValue' element value. This functionality requires activation and is controlled by settings in the Ticketing Options Table (maintained by Sabre) and CAT31 fare filings. When active, the system does not include a residual value from an exchange document in the grand total of the report.
     * 
     * @param ignoredResidualValue
     */
    public void setIgnoredResidualValue(MiscMoney ignoredResidualValue) {
        this.ignoredResidualValue = ignoredResidualValue;
    }

    /** 
     * Get the 'EvenExchangeShortage' element value. Total amount of shortage from an even exchange transactions
     * 
     * @return value
     */
    public MiscMoney getEvenExchangeShortage() {
        return evenExchangeShortage;
    }

    /** 
     * Set the 'EvenExchangeShortage' element value. Total amount of shortage from an even exchange transactions
     * 
     * @param evenExchangeShortage
     */
    public void setEvenExchangeShortage(MiscMoney evenExchangeShortage) {
        this.evenExchangeShortage = evenExchangeShortage;
    }

    /** 
     * Get the 'EvenExchangeOverage' element value. Total amount of overage from an even exchange transactions.
     * 
     * @return value
     */
    public MiscMoney getEvenExchangeOverage() {
        return evenExchangeOverage;
    }

    /** 
     * Set the 'EvenExchangeOverage' element value. Total amount of overage from an even exchange transactions.
     * 
     * @param evenExchangeOverage
     */
    public void setEvenExchangeOverage(MiscMoney evenExchangeOverage) {
        this.evenExchangeOverage = evenExchangeOverage;
    }

    /** 
     * Get the list of 'DocTypeAmount' element items.
     * 
     * @return list
     */
    public List<DocTypeAmount> getDocTypeAmountList() {
        return docTypeAmountList;
    }

    /** 
     * Set the list of 'DocTypeAmount' element items.
     * 
     * @param list
     */
    public void setDocTypeAmountList(List<DocTypeAmount> list) {
        docTypeAmountList = list;
    }
    /** 
     * Total amount of Voucher transactions
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vouchers" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:integer" use="required" name="numDocs"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Vouchers implements Serializable
    {
        private MiscMoney miscMoney;
        private BigInteger numDocs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'numDocs' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumDocs() {
            return numDocs;
        }

        /** 
         * Set the 'numDocs' attribute value.
         * 
         * @param numDocs
         */
        public void setNumDocs(BigInteger numDocs) {
            this.numDocs = numDocs;
        }
    }
    /** 
     * Total amount of Pre-Paid transactions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrepaidAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:integer" use="required" name="numDocs"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PrepaidAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private BigInteger numDocs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'numDocs' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumDocs() {
            return numDocs;
        }

        /** 
         * Set the 'numDocs' attribute value.
         * 
         * @param numDocs
         */
        public void setNumDocs(BigInteger numDocs) {
            this.numDocs = numDocs;
        }
    }
    /** 
     * Total amount of exchange transactions
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:integer" use="required" name="numDocs"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ExchangeAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private BigInteger numDocs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'numDocs' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumDocs() {
            return numDocs;
        }

        /** 
         * Set the 'numDocs' attribute value.
         * 
         * @param numDocs
         */
        public void setNumDocs(BigInteger numDocs) {
            this.numDocs = numDocs;
        }
    }
    /** 
     * Total amount of each document type.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocTypeAmount" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="documentType"/>
     *         &lt;xs:attribute type="xs:integer" use="required" name="numDocs"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DocTypeAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String documentType;
        private BigInteger numDocs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'documentType' attribute value.
         * 
         * @return value
         */
        public String getDocumentType() {
            return documentType;
        }

        /** 
         * Set the 'documentType' attribute value.
         * 
         * @param documentType
         */
        public void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        /** 
         * Get the 'numDocs' attribute value.
         * 
         * @return value
         */
        public BigInteger getNumDocs() {
            return numDocs;
        }

        /** 
         * Set the 'numDocs' attribute value.
         * 
         * @param numDocs
         */
        public void setNumDocs(BigInteger numDocs) {
            this.numDocs = numDocs;
        }
    }
}
