
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.sql.Date;

/** 
 * Present if any adjustments have been made to this station.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumAdjustments">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="AdjustmentDate"/>
 *     &lt;xs:element type="xs:string" name="EmployeeName"/>
 *     &lt;xs:element type="xs:string" name="EmployeeNumber"/>
 *     &lt;xs:element name="AdjustmentAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class AdjustmentAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="AdjustmentRemark"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumAdjustments implements Serializable
{
    private Date adjustmentDate;
    private String employeeName;
    private String employeeNumber;
    private AdjustmentAmount adjustmentAmount;
    private String adjustmentRemark;

    /** 
     * Get the 'AdjustmentDate' element value. Date adjustment was made.
     * 
     * @return value
     */
    public Date getAdjustmentDate() {
        return adjustmentDate;
    }

    /** 
     * Set the 'AdjustmentDate' element value. Date adjustment was made.
     * 
     * @param adjustmentDate
     */
    public void setAdjustmentDate(Date adjustmentDate) {
        this.adjustmentDate = adjustmentDate;
    }

    /** 
     * Get the 'EmployeeName' element value. Employee name who made the adjustment.
     * 
     * @return value
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /** 
     * Set the 'EmployeeName' element value. Employee name who made the adjustment.
     * 
     * @param employeeName
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /** 
     * Get the 'EmployeeNumber' element value. Employee number who made the adjustment.
     * 
     * @return value
     */
    public String getEmployeeNumber() {
        return employeeNumber;
    }

    /** 
     * Set the 'EmployeeNumber' element value. Employee number who made the adjustment.
     * 
     * @param employeeNumber
     */
    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    /** 
     * Get the 'AdjustmentAmount' element value.
     * 
     * @return value
     */
    public AdjustmentAmount getAdjustmentAmount() {
        return adjustmentAmount;
    }

    /** 
     * Set the 'AdjustmentAmount' element value.
     * 
     * @param adjustmentAmount
     */
    public void setAdjustmentAmount(AdjustmentAmount adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    /** 
     * Get the 'AdjustmentRemark' element value. Explanation for the adjustment.
     * 
     * @return value
     */
    public String getAdjustmentRemark() {
        return adjustmentRemark;
    }

    /** 
     * Set the 'AdjustmentRemark' element value. Explanation for the adjustment.
     * 
     * @param adjustmentRemark
     */
    public void setAdjustmentRemark(String adjustmentRemark) {
        this.adjustmentRemark = adjustmentRemark;
    }
    /** 
     * Amount of the adjustment.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdjustmentAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *         &lt;xs:attribute type="ns:Code.CashCheckIndicator" use="required" name="cashCheckIndicator"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdjustmentAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;
        private CodeCashCheckIndicator cashCheckIndicator;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        /** 
         * Get the 'cashCheckIndicator' attribute value.
         * 
         * @return value
         */
        public CodeCashCheckIndicator getCashCheckIndicator() {
            return cashCheckIndicator;
        }

        /** 
         * Set the 'cashCheckIndicator' attribute value.
         * 
         * @param cashCheckIndicator
         */
        public void setCashCheckIndicator(
                CodeCashCheckIndicator cashCheckIndicator) {
            this.cashCheckIndicator = cashCheckIndicator;
        }
    }
}
