
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.CodeOverShortCode;
import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * List of all reconciliations and subtotals made to this station per currency.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumAgentReconciliation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element name="OverShortAmount" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OverShortAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:Misc.Money" name="BeforeAmount"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="AfterAmount"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="TotalOverShortAmount"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumAgentReconciliation implements Serializable
{
    private String currencyCode;
    private List<OverShortAmount> overShortAmountList = new ArrayList<OverShortAmount>();
    private MiscMoney beforeAmount;
    private MiscMoney afterAmount;
    private MiscMoney totalOverShortAmount;

    /** 
     * Get the 'CurrencyCode' element value. Currency of the adjustment.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the adjustment.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the list of 'OverShortAmount' element items.
     * 
     * @return list
     */
    public List<OverShortAmount> getOverShortAmountList() {
        return overShortAmountList;
    }

    /** 
     * Set the list of 'OverShortAmount' element items.
     * 
     * @param list
     */
    public void setOverShortAmountList(List<OverShortAmount> list) {
        overShortAmountList = list;
    }

    /** 
     * Get the 'BeforeAmount' element value. Station total cash/check before reconciliation.
     * 
     * @return value
     */
    public MiscMoney getBeforeAmount() {
        return beforeAmount;
    }

    /** 
     * Set the 'BeforeAmount' element value. Station total cash/check before reconciliation.
     * 
     * @param beforeAmount
     */
    public void setBeforeAmount(MiscMoney beforeAmount) {
        this.beforeAmount = beforeAmount;
    }

    /** 
     * Get the 'AfterAmount' element value. Station total cash/check after reconciliation.
     * 
     * @return value
     */
    public MiscMoney getAfterAmount() {
        return afterAmount;
    }

    /** 
     * Set the 'AfterAmount' element value. Station total cash/check after reconciliation.
     * 
     * @param afterAmount
     */
    public void setAfterAmount(MiscMoney afterAmount) {
        this.afterAmount = afterAmount;
    }

    /** 
     * Get the 'TotalOverShortAmount' element value. Station total over/short amount.
     * 
     * @return value
     */
    public MiscMoney getTotalOverShortAmount() {
        return totalOverShortAmount;
    }

    /** 
     * Set the 'TotalOverShortAmount' element value. Station total over/short amount.
     * 
     * @param totalOverShortAmount
     */
    public void setTotalOverShortAmount(MiscMoney totalOverShortAmount) {
        this.totalOverShortAmount = totalOverShortAmount;
    }
    /** 
     * Over/Short amount for an agent reconciliation made to this station.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OverShortAmount" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="ns1:Code.OverShortCode" use="required" name="overShortCode"/>
     *         &lt;xs:attribute type="xs:string" use="required" name="employeeNumber"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OverShortAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private CodeOverShortCode overShortCode;
        private String employeeNumber;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'overShortCode' attribute value.
         * 
         * @return value
         */
        public CodeOverShortCode getOverShortCode() {
            return overShortCode;
        }

        /** 
         * Set the 'overShortCode' attribute value.
         * 
         * @param overShortCode
         */
        public void setOverShortCode(CodeOverShortCode overShortCode) {
            this.overShortCode = overShortCode;
        }

        /** 
         * Get the 'employeeNumber' attribute value.
         * 
         * @return value
         */
        public String getEmployeeNumber() {
            return employeeNumber;
        }

        /** 
         * Set the 'employeeNumber' attribute value.
         * 
         * @param employeeNumber
         */
        public void setEmployeeNumber(String employeeNumber) {
            this.employeeNumber = employeeNumber;
        }
    }
}
