
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumSalesFop">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FopCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CreditCardVendor" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="RefundAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="NetFareAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="TotalAmount"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumSalesFop implements Serializable
{
    private String fopCode;
    private String creditCardVendor;
    private MiscMoney refundAmount;
    private MiscMoney netFareAmount;
    private MiscMoney totalAmount;

    /** 
     * Get the 'FopCode' element value. Form of Payment for this transaction.
     * 
     * @return value
     */
    public String getFopCode() {
        return fopCode;
    }

    /** 
     * Set the 'FopCode' element value. Form of Payment for this transaction.
     * 
     * @param fopCode
     */
    public void setFopCode(String fopCode) {
        this.fopCode = fopCode;
    }

    /** 
     * Get the 'CreditCardVendor' element value. Vendor code if document was purchased with a credit card.
     * 
     * @return value
     */
    public String getCreditCardVendor() {
        return creditCardVendor;
    }

    /** 
     * Set the 'CreditCardVendor' element value. Vendor code if document was purchased with a credit card.
     * 
     * @param creditCardVendor
     */
    public void setCreditCardVendor(String creditCardVendor) {
        this.creditCardVendor = creditCardVendor;
    }

    /** 
     * Get the 'RefundAmount' element value. Total refund amount for form of payment type.
     * 
     * @return value
     */
    public MiscMoney getRefundAmount() {
        return refundAmount;
    }

    /** 
     * Set the 'RefundAmount' element value. Total refund amount for form of payment type.
     * 
     * @param refundAmount
     */
    public void setRefundAmount(MiscMoney refundAmount) {
        this.refundAmount = refundAmount;
    }

    /** 
     * Get the 'NetFareAmount' element value. Total net fare amount for form of payment type.
     * 
     * @return value
     */
    public MiscMoney getNetFareAmount() {
        return netFareAmount;
    }

    /** 
     * Set the 'NetFareAmount' element value. Total net fare amount for form of payment type.
     * 
     * @param netFareAmount
     */
    public void setNetFareAmount(MiscMoney netFareAmount) {
        this.netFareAmount = netFareAmount;
    }

    /** 
     * Get the 'TotalAmount' element value. Total fare plus net fare minus refunds for form of payment type.  A negative amount will preceded by a negative sign.
     * 
     * @return value
     */
    public MiscMoney getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Total fare plus net fare minus refunds for form of payment type.  A negative amount will preceded by a negative sign.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(MiscMoney totalAmount) {
        this.totalAmount = totalAmount;
    }
}
