
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumSelectionCriteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Code.StaSumReportOperation" name="ReportOperation"/>
 *     &lt;xs:element type="xs:string" name="TicketingProvider"/>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *     &lt;xs:element type="xs:date" name="ReportDate"/>
 *     &lt;xs:element name="Remark" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class Remark -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="isTotalsOnly" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="isTaxesOnly" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="isAdjustmentAndRemarksOnly" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isCacheLateLargeReports"/>
 *   &lt;xs:attribute type="xs:integer" name="clientTimeoutSecs"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumSelectionCriteria implements Serializable
{
    private CodeStaSumReportOperation reportOperation;
    private String ticketingProvider;
    private String stationNumber;
    private Date reportDate;
    private Remark remark;
    private Boolean isTotalsOnly;
    private Boolean isTaxesOnly;
    private Boolean isAdjustmentAndRemarksOnly;
    private Boolean isCacheLateLargeReports;
    private BigInteger clientTimeoutSecs;

    /** 
     * Get the 'ReportOperation' element value. The report operation allows use of this same RQ for different purposes. 
     * 
     * @return value
     */
    public CodeStaSumReportOperation getReportOperation() {
        return reportOperation;
    }

    /** 
     * Set the 'ReportOperation' element value. The report operation allows use of this same RQ for different purposes. 
     * 
     * @param reportOperation
     */
    public void setReportOperation(CodeStaSumReportOperation reportOperation) {
        this.reportOperation = reportOperation;
    }

    /** 
     * Get the 'TicketingProvider' element value. Carrier to pull data from.
     * 
     * @return value
     */
    public String getTicketingProvider() {
        return ticketingProvider;
    }

    /** 
     * Set the 'TicketingProvider' element value. Carrier to pull data from.
     * 
     * @param ticketingProvider
     */
    public void setTicketingProvider(String ticketingProvider) {
        this.ticketingProvider = ticketingProvider;
    }

    /** 
     * Get the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** 
     * Get the 'ReportDate' element value. Report data will be limited to this date.  Each report can only contain data for one day.
     * 
     * @return value
     */
    public Date getReportDate() {
        return reportDate;
    }

    /** 
     * Set the 'ReportDate' element value. Report data will be limited to this date.  Each report can only contain data for one day.
     * 
     * @param reportDate
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /** 
     * Get the 'Remark' element value.
     * 
     * @return value
     */
    public Remark getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value.
     * 
     * @param remark
     */
    public void setRemark(Remark remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'isTotalsOnly' element value. Only one of the 3 reports may be selected.
    If none are selected, the entire report will be returned

     * 
     * @return value
     */
    public Boolean getIsTotalsOnly() {
        return isTotalsOnly;
    }

    /** 
     * Set the 'isTotalsOnly' element value. Only one of the 3 reports may be selected.
    If none are selected, the entire report will be returned

     * 
     * @param isTotalsOnly
     */
    public void setIsTotalsOnly(Boolean isTotalsOnly) {
        this.isTotalsOnly = isTotalsOnly;
    }

    /** 
     * Get the 'isTaxesOnly' element value. Only one of the 3 reports may be selected.
    If none are selected, the entire report will be returned

     * 
     * @return value
     */
    public Boolean getIsTaxesOnly() {
        return isTaxesOnly;
    }

    /** 
     * Set the 'isTaxesOnly' element value. Only one of the 3 reports may be selected.
    If none are selected, the entire report will be returned

     * 
     * @param isTaxesOnly
     */
    public void setIsTaxesOnly(Boolean isTaxesOnly) {
        this.isTaxesOnly = isTaxesOnly;
    }

    /** 
     * Get the 'isAdjustmentAndRemarksOnly' element value. Only one of the 3 reports may be selected.
    If none are selected, the entire report will be returned

     * 
     * @return value
     */
    public Boolean getIsAdjustmentAndRemarksOnly() {
        return isAdjustmentAndRemarksOnly;
    }

    /** 
     * Set the 'isAdjustmentAndRemarksOnly' element value. Only one of the 3 reports may be selected.
    If none are selected, the entire report will be returned

     * 
     * @param isAdjustmentAndRemarksOnly
     */
    public void setIsAdjustmentAndRemarksOnly(Boolean isAdjustmentAndRemarksOnly) {
        this.isAdjustmentAndRemarksOnly = isAdjustmentAndRemarksOnly;
    }

    /** 
     * Get the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public Boolean getIsCacheLateLargeReports() {
        return isCacheLateLargeReports;
    }

    /** 
     * Set the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @param isCacheLateLargeReports
     */
    public void setIsCacheLateLargeReports(Boolean isCacheLateLargeReports) {
        this.isCacheLateLargeReports = isCacheLateLargeReports;
    }

    /** 
     * Get the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public BigInteger getClientTimeoutSecs() {
        return clientTimeoutSecs;
    }

    /** 
     * Set the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @param clientTimeoutSecs
     */
    public void setClientTimeoutSecs(BigInteger clientTimeoutSecs) {
        this.clientTimeoutSecs = clientTimeoutSecs;
    }
    /** 
     * The text remark. 300 characters max
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:integer" name="sequenceNumber"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String string;
        private BigInteger sequenceNumber;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'sequenceNumber' attribute value.
         * 
         * @return value
         */
        public BigInteger getSequenceNumber() {
            return sequenceNumber;
        }

        /** 
         * Set the 'sequenceNumber' attribute value.
         * 
         * @param sequenceNumber
         */
        public void setSequenceNumber(BigInteger sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }
    }
}
