
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumTaxes">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TaxAmount" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TaxAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:Misc.Money" name="TaxTotal"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumTaxes implements Serializable
{
    private List<TaxAmount> taxAmountList = new ArrayList<TaxAmount>();
    private MiscMoney taxTotal;
    private String currencyCode;

    /** 
     * Get the list of 'TaxAmount' element items.
     * 
     * @return list
     */
    public List<TaxAmount> getTaxAmountList() {
        return taxAmountList;
    }

    /** 
     * Set the list of 'TaxAmount' element items.
     * 
     * @param list
     */
    public void setTaxAmountList(List<TaxAmount> list) {
        taxAmountList = list;
    }

    /** 
     * Get the 'TaxTotal' element value. Total taxes collected for the station.
     * 
     * @return value
     */
    public MiscMoney getTaxTotal() {
        return taxTotal;
    }

    /** 
     * Set the 'TaxTotal' element value. Total taxes collected for the station.
     * 
     * @param taxTotal
     */
    public void setTaxTotal(MiscMoney taxTotal) {
        this.taxTotal = taxTotal;
    }

    /** 
     * Get the 'currencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'currencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
    /** 
     * Taxes collected for the station by tax type.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxAmount" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="taxCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TaxAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String taxCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'taxCode' attribute value.
         * 
         * @return value
         */
        public String getTaxCode() {
            return taxCode;
        }

        /** 
         * Set the 'taxCode' attribute value.
         * 
         * @param taxCode
         */
        public void setTaxCode(String taxCode) {
            this.taxCode = taxCode;
        }
    }
}
