
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRQ;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StationSummaryRQ">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RQ" name="Header"/>
 *     &lt;xs:element type="ns1:_StaSumSelectionCriteria" name="SelectionCriteria"/>
 *     &lt;xs:element type="ns1:_StaSumAdjustmentDetails" name="AdjustmentDetails" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_StaSumActualStationTotals" name="ActualStationTotals" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StationSummaryRQ implements Serializable
{
    private STLHeaderRQ header;
    private _StaSumSelectionCriteria selectionCriteria;
    private _StaSumAdjustmentDetails adjustmentDetails;
    private _StaSumActualStationTotals actualStationTotals;
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;

    /** 
     * Get the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @return value
     */
    public STLHeaderRQ getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @param header
     */
    public void setHeader(STLHeaderRQ header) {
        this.header = header;
    }

    /** 
     * Get the 'SelectionCriteria' element value. Elements used to define what should be included in the report including optional filters. 
     * 
     * @return value
     */
    public _StaSumSelectionCriteria getSelectionCriteria() {
        return selectionCriteria;
    }

    /** 
     * Set the 'SelectionCriteria' element value. Elements used to define what should be included in the report including optional filters. 
     * 
     * @param selectionCriteria
     */
    public void setSelectionCriteria(_StaSumSelectionCriteria selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
    }

    /** 
     * Get the 'AdjustmentDetails' element value. Adjustment funds collected by an agent
     * 
     * @return value
     */
    public _StaSumAdjustmentDetails getAdjustmentDetails() {
        return adjustmentDetails;
    }

    /** 
     * Set the 'AdjustmentDetails' element value. Adjustment funds collected by an agent
     * 
     * @param adjustmentDetails
     */
    public void setAdjustmentDetails(_StaSumAdjustmentDetails adjustmentDetails) {
        this.adjustmentDetails = adjustmentDetails;
    }

    /** 
     * Get the 'ActualStationTotals' element value. Cash and check actuals collected for the station with an overage/shortage remark if amounts don’t match expected totals. 
     * 
     * @return value
     */
    public _StaSumActualStationTotals getActualStationTotals() {
        return actualStationTotals;
    }

    /** 
     * Set the 'ActualStationTotals' element value. Cash and check actuals collected for the station with an overage/shortage remark if amounts don’t match expected totals. 
     * 
     * @param actualStationTotals
     */
    public void setActualStationTotals(
            _StaSumActualStationTotals actualStationTotals) {
        this.actualStationTotals = actualStationTotals;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
