
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRQ;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_TaxRQ">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RQ" name="Header"/>
 *     &lt;xs:element type="ns1:_TaxSelectionCriteria" name="SelectionCriteria"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _TaxRQ implements Serializable
{
    private STLHeaderRQ header;
    private _TaxSelectionCriteria selectionCriteria;
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;

    /** 
     * Get the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @return value
     */
    public STLHeaderRQ getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @param header
     */
    public void setHeader(STLHeaderRQ header) {
        this.header = header;
    }

    /** 
     * Get the 'SelectionCriteria' element value. Used to define what should be included in the Tax report including optional filters.
     * 
     * @return value
     */
    public _TaxSelectionCriteria getSelectionCriteria() {
        return selectionCriteria;
    }

    /** 
     * Set the 'SelectionCriteria' element value. Used to define what should be included in the Tax report including optional filters.
     * 
     * @param selectionCriteria
     */
    public void setSelectionCriteria(_TaxSelectionCriteria selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
