
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_TaxSelectionCriteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketingProvider"/>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *     &lt;xs:element type="xs:string" name="EmployeeNumber"/>
 *     &lt;xs:element type="xs:date" name="ReportDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="DocumentType" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="TaxCode" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="Lniata" minOccurs="0" maxOccurs="5"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isCacheLateLargeReports"/>
 *   &lt;xs:attribute type="xs:integer" name="clientTimeoutSecs"/>
 *   &lt;xs:attribute type="xs:boolean" name="isElectronicTicket"/>
 *   &lt;xs:attribute type="xs:boolean" name="isManuallyAdded"/>
 *   &lt;xs:attribute type="xs:boolean" name="isNetRemitTransaction"/>
 *   &lt;xs:attribute type="xs:boolean" name="isVoidedTransaction"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _TaxSelectionCriteria implements Serializable
{
    private String ticketingProvider;
    private String stationNumber;
    private String employeeNumber;
    private Date reportDate;
    private List<String> currencyCodeList = new ArrayList<String>();
    private List<String> documentTypeList = new ArrayList<String>();
    private List<String> taxCodeList = new ArrayList<String>();
    private List<String> lniataList = new ArrayList<String>();
    private Boolean isCacheLateLargeReports;
    private BigInteger clientTimeoutSecs;
    private Boolean isElectronicTicket;
    private Boolean isManuallyAdded;
    private Boolean isNetRemitTransaction;
    private Boolean isVoidedTransaction;

    /** 
     * Get the 'TicketingProvider' element value. Carrier to pull data from.
     * 
     * @return value
     */
    public String getTicketingProvider() {
        return ticketingProvider;
    }

    /** 
     * Set the 'TicketingProvider' element value. Carrier to pull data from.
     * 
     * @param ticketingProvider
     */
    public void setTicketingProvider(String ticketingProvider) {
        this.ticketingProvider = ticketingProvider;
    }

    /** 
     * Get the 'StationNumber' element value. Only taxes collected at this station will be returned.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Only taxes collected at this station will be returned.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** 
     * Get the 'EmployeeNumber' element value. only taxes collected by this agent will be returned.
     * 
     * @return value
     */
    public String getEmployeeNumber() {
        return employeeNumber;
    }

    /** 
     * Set the 'EmployeeNumber' element value. only taxes collected by this agent will be returned.
     * 
     * @param employeeNumber
     */
    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    /** 
     * Get the 'ReportDate' element value. Report data will be limited to this date.  Each report can only contain data for one day.
     * 
     * @return value
     */
    public Date getReportDate() {
        return reportDate;
    }

    /** 
     * Set the 'ReportDate' element value. Report data will be limited to this date.  Each report can only contain data for one day.
     * 
     * @param reportDate
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    /** 
     * Get the list of 'CurrencyCode' element items. only taxes collected in this currency will be returned.
     * 
     * @return list
     */
    public List<String> getCurrencyCodeList() {
        return currencyCodeList;
    }

    /** 
     * Set the list of 'CurrencyCode' element items. only taxes collected in this currency will be returned.
     * 
     * @param list
     */
    public void setCurrencyCodeList(List<String> list) {
        currencyCodeList = list;
    }

    /** 
     * Get the list of 'DocumentType' element items. Only taxes collected for documents of this type will be returned.
     * 
     * @return list
     */
    public List<String> getDocumentTypeList() {
        return documentTypeList;
    }

    /** 
     * Set the list of 'DocumentType' element items. Only taxes collected for documents of this type will be returned.
     * 
     * @param list
     */
    public void setDocumentTypeList(List<String> list) {
        documentTypeList = list;
    }

    /** 
     * Get the list of 'TaxCode' element items. Only taxes of this type will be returned.
     * 
     * @return list
     */
    public List<String> getTaxCodeList() {
        return taxCodeList;
    }

    /** 
     * Set the list of 'TaxCode' element items. Only taxes of this type will be returned.
     * 
     * @param list
     */
    public void setTaxCodeList(List<String> list) {
        taxCodeList = list;
    }

    /** 
     * Get the list of 'Lniata' element items. Only taxes collected for documents issued by this line IATA printer will be returned.
     * 
     * @return list
     */
    public List<String> getLniataList() {
        return lniataList;
    }

    /** 
     * Set the list of 'Lniata' element items. Only taxes collected for documents issued by this line IATA printer will be returned.
     * 
     * @param list
     */
    public void setLniataList(List<String> list) {
        lniataList = list;
    }

    /** 
     * Get the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public Boolean getIsCacheLateLargeReports() {
        return isCacheLateLargeReports;
    }

    /** 
     * Set the 'isCacheLateLargeReports' attribute value. The client can specify if it wants the system to cache a report if it is demmed too large to return in one XML document or if the report query runs too long and won't complete before the system timeout.  If this is set to true the system will cache the report and the client can retrive the report at a later time using CachedReportRQ.
     * 
     * @param isCacheLateLargeReports
     */
    public void setIsCacheLateLargeReports(Boolean isCacheLateLargeReports) {
        this.isCacheLateLargeReports = isCacheLateLargeReports;
    }

    /** 
     * Get the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @return value
     */
    public BigInteger getClientTimeoutSecs() {
        return clientTimeoutSecs;
    }

    /** 
     * Set the 'clientTimeoutSecs' attribute value. The client can specify a smaller timeout which the system will use to determine if a report will be returned late.  If the query won't finish in time the system will cache the report and the client can retrieve the report at a later time using CachedReportRQ.
     * 
     * @param clientTimeoutSecs
     */
    public void setClientTimeoutSecs(BigInteger clientTimeoutSecs) {
        this.clientTimeoutSecs = clientTimeoutSecs;
    }

    /** 
     * Get the 'isElectronicTicket' attribute value. Only electronic documents will be returned.
     * 
     * @return value
     */
    public Boolean getIsElectronicTicket() {
        return isElectronicTicket;
    }

    /** 
     * Set the 'isElectronicTicket' attribute value. Only electronic documents will be returned.
     * 
     * @param isElectronicTicket
     */
    public void setIsElectronicTicket(Boolean isElectronicTicket) {
        this.isElectronicTicket = isElectronicTicket;
    }

    /** 
     * Get the 'isManuallyAdded' attribute value. Only documents manually added to an agent sales report will be returned.
     * 
     * @return value
     */
    public Boolean getIsManuallyAdded() {
        return isManuallyAdded;
    }

    /** 
     * Set the 'isManuallyAdded' attribute value. Only documents manually added to an agent sales report will be returned.
     * 
     * @param isManuallyAdded
     */
    public void setIsManuallyAdded(Boolean isManuallyAdded) {
        this.isManuallyAdded = isManuallyAdded;
    }

    /** 
     * Get the 'isNetRemitTransaction' attribute value. Only net remit transactions will be returned.
     * 
     * @return value
     */
    public Boolean getIsNetRemitTransaction() {
        return isNetRemitTransaction;
    }

    /** 
     * Set the 'isNetRemitTransaction' attribute value. Only net remit transactions will be returned.
     * 
     * @param isNetRemitTransaction
     */
    public void setIsNetRemitTransaction(Boolean isNetRemitTransaction) {
        this.isNetRemitTransaction = isNetRemitTransaction;
    }

    /** 
     * Get the 'isVoidedTransaction' attribute value. Only voided transactions will be returned.
     * 
     * @return value
     */
    public Boolean getIsVoidedTransaction() {
        return isVoidedTransaction;
    }

    /** 
     * Set the 'isVoidedTransaction' attribute value. Only voided transactions will be returned.
     * 
     * @param isVoidedTransaction
     */
    public void setIsVoidedTransaction(Boolean isVoidedTransaction) {
        this.isVoidedTransaction = isVoidedTransaction;
    }
}
