import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import org.apache.commons.lang.StringUtils

def query = new SearchQuery()
def data = []
query.criteria.criterions.add(SearchCriterion.eq(GdsAccountIndex.Property.gds.name(), GdsName.SABRE))
EntityStorage.get().search(GdsAccountIndex.class, query).data.each {
    def ctr = EntityStorage.get().resolve(it.source)
    SabreGdsAccount acc = ctr.entity
    if (!StringUtils.isBlank(acc.address) && !acc.address.contains(".platform.")) {
        data.add("${acc.name} (${ctr.uid}): [${acc.address}]")
    }
}

if (!data.isEmpty()) {
    answer.booleanData = true
    answer.textData = data.join("\r\n")
}
