
package com.gridnine.sabre.jaxws.ota2.message;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Enum_ProcessingCondition.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="Enum_ProcessingCondition">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Advisory"/>
 *     &lt;enumeration value="ApplicationError"/>
 *     &lt;enumeration value="AuthenticalModel"/>
 *     &lt;enumeration value="Authentication"/>
 *     &lt;enumeration value="AuthenticationTimeout"/>
 *     &lt;enumeration value="Authorization"/>
 *     &lt;enumeration value="BusinessRule"/>
 *     &lt;enumeration value="NoImplementation"/>
 *     &lt;enumeration value="ProcessingException"/>
 *     &lt;enumeration value="ProtocolViolation"/>
 *     &lt;enumeration value="RequiredFieldMissing"/>
 *     &lt;enumeration value="TransactionModel"/>
 *     &lt;enumeration value="Unknown"/>
 *     &lt;enumeration value="Other_"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Enum_ProcessingCondition")
@XmlEnum
public enum EnumProcessingCondition {

    @XmlEnumValue("Advisory")
    ADVISORY("Advisory"),

    /**
     * Indicates that an involved backend application returned an error or warning, which is passed back in the response message.
     * 
     */
    @XmlEnumValue("ApplicationError")
    APPLICATION_ERROR("ApplicationError"),

    /**
     * Indicates the type of authentication requested is not recognized.
     * 
     */
    @XmlEnumValue("AuthenticalModel")
    AUTHENTICAL_MODEL("AuthenticalModel"),

    /**
     * Indicates the message lacks adequate security credentials.
     * 
     */
    @XmlEnumValue("Authentication")
    AUTHENTICATION("Authentication"),

    /**
     * Indicates that the security credentials in the message have expired.
     * 
     */
    @XmlEnumValue("AuthenticationTimeout")
    AUTHENTICATION_TIMEOUT("AuthenticationTimeout"),

    /**
     * Indicates the message lacks adequate security credentials.
     * 
     */
    @XmlEnumValue("Authorization")
    AUTHORIZATION("Authorization"),

    /**
     * Indicates that the XML message has passed a low-level validation check, but that the business rules for the request message were not met.
     * 
     */
    @XmlEnumValue("BusinessRule")
    BUSINESS_RULE("BusinessRule"),

    /**
     * Indicates that the target business system has no implementation for the intended request.
     * 
     */
    @XmlEnumValue("NoImplementation")
    NO_IMPLEMENTATION("NoImplementation"),

    /**
     * Indicates that during processing of the request that a not further defined exception occurred.
     * 
     */
    @XmlEnumValue("ProcessingException")
    PROCESSING_EXCEPTION("ProcessingException"),

    /**
     * Indicates that a request was sent within a message exchange that does not align to the message.
     * 
     */
    @XmlEnumValue("ProtocolViolation")
    PROTOCOL_VIOLATION("ProtocolViolation"),

    /**
     * Indicates that an element or attribute that is required in by the schema (or required by agreement between trading partners) is missing from the message.
     * 
     */
    @XmlEnumValue("RequiredFieldMissing")
    REQUIRED_FIELD_MISSING("RequiredFieldMissing"),

    /**
     * Indicates that the target business system does not support the intended transaction-oriented operation.
     * 
     */
    @XmlEnumValue("TransactionModel")
    TRANSACTION_MODEL("TransactionModel"),

    /**
     * Indicates an unknown error.
     * 
     */
    @XmlEnumValue("Unknown")
    UNKNOWN("Unknown"),
    @XmlEnumValue("Other_")
    OTHER("Other_");
    private final String value;

    EnumProcessingCondition(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static EnumProcessingCondition fromValue(String v) {
        for (EnumProcessingCondition c: EnumProcessingCondition.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
