
package com.gridnine.sabre.jaxws.ota2.message;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import com.gridnine.sabre.jaxws.ota2.builtins.EnumBookingChannelBase;
import com.gridnine.sabre.jaxws.ota2.builtins.EnumTravelSectorBase;
import com.gridnine.sabre.jaxws.ota2.builtins.TimeZone;


/**
 * Message Header definition: The standard element that appears on the root all OpenTravel 2 messages.
 * 
 * <p>Java class for MessageHeader complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="MessageHeader">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Identification">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="timeStamp" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *                 &lt;attribute name="messageID" type="{http://opentravel.org/common/v02}String_Short" />
 *                 &lt;attribute name="correlationID" type="{http://opentravel.org/common/v02}String_Medium" />
 *                 &lt;attribute name="sequenceNbr" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="TargetSystem" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="type">
 *                   &lt;simpleType>
 *                     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
 *                       &lt;enumeration value="Production"/>
 *                       &lt;enumeration value="Test"/>
 *                     &lt;/restriction>
 *                   &lt;/simpleType>
 *                 &lt;/attribute>
 *                 &lt;attribute name="name" type="{http://opentravel.org/common/v02}String_Short" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="Language" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="primary" type="{http://www.w3.org/2001/XMLSchema}language" />
 *                 &lt;attribute name="secondary" type="{http://www.w3.org/2001/XMLSchema}language" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="Correlation" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="PointOfSale" maxOccurs="99">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;sequence>
 *                   &lt;element name="Type">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="Company" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                   &lt;element name="BookingChannelInfo" minOccurs="0">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;sequence minOccurs="0">
 *                             &lt;element name="Type">
 *                               &lt;complexType>
 *                                 &lt;simpleContent>
 *                                   &lt;extension base="&lt;http://opentravel.org/common/v02>Enum_BookingChannel_Base">
 *                                     &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
 *                                   &lt;/extension>
 *                                 &lt;/simpleContent>
 *                               &lt;/complexType>
 *                             &lt;/element>
 *                             &lt;element name="Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                           &lt;/sequence>
 *                           &lt;attribute name="primaryInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *                           &lt;attribute name="id" type="{http://opentravel.org/common/v02}String_Short" />
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="Agent" minOccurs="0">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;attribute name="sine" type="{http://opentravel.org/common/v02}String_Short" />
 *                           &lt;attribute name="pseudoCityCode" type="{http://opentravel.org/common/v02}Code_PseudoCity" />
 *                           &lt;attribute name="dutyCode" type="{http://opentravel.org/common/v02}Code_AgentDuty" />
 *                           &lt;attribute name="terminalID" type="{http://opentravel.org/common/v02}String_Short" />
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="AirInfo" minOccurs="0">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;attribute name="ERSP" type="{http://opentravel.org/common/v02}Code_IATA_ERSP" />
 *                           &lt;attribute name="airlineVendorID" type="{http://opentravel.org/common/v02}Code_IATA_AirlineID" />
 *                           &lt;attribute name="airportCode" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" />
 *                           &lt;attribute name="firstDeparturePoint" type="{http://opentravel.org/common/v02}Code_IATA_Airport" />
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="Location" minOccurs="0">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;sequence>
 *                             &lt;element name="TimeZone" type="{http://opentravel.org/common/v02}TimeZone" minOccurs="0"/>
 *                           &lt;/sequence>
 *                           &lt;attribute name="ISOCountry" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" />
 *                           &lt;attribute name="ISOCurrency" type="{http://opentravel.org/common/v02}Code_ISO_Currency" />
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="Position" type="{http://opentravel.org/common/v02}String_Short" minOccurs="0"/>
 *                 &lt;/sequence>
 *                 &lt;attribute name="requestorID" use="required" type="{http://opentravel.org/common/v02}String_Short" />
 *                 &lt;attribute name="idContext" type="{http://opentravel.org/common/v02}String_Short" />
 *                 &lt;attribute name="url" type="{http://opentravel.org/common/v02}URL" />
 *                 &lt;attribute name="travelSegment" type="{http://opentravel.org/common/v02}Enum_TravelSector_Base" />
 *                 &lt;attribute name="messagePassword" type="{http://opentravel.org/common/v02}String_Short" />
 *                 &lt;attribute name="domain" type="{http://opentravel.org/common/v02}String_Short" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="Results" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="failureInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *                 &lt;attribute name="status" use="required">
 *                   &lt;simpleType>
 *                     &lt;restriction base="{http://opentravel.org/common/message/v02}Enum_ProcessingStatus">
 *                     &lt;/restriction>
 *                   &lt;/simpleType>
 *                 &lt;/attribute>
 *                 &lt;attribute name="retryInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *                 &lt;attribute name="compensationInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MessageHeader", propOrder = {
    "identification",
    "targetSystem",
    "language",
    "correlation",
    "pointOfSale",
    "results"
})
public class MessageHeader
    implements Serializable
{

    @XmlElement(name = "Identification", required = true)
    protected MessageHeader.Identification identification;
    @XmlElement(name = "TargetSystem")
    protected MessageHeader.TargetSystem targetSystem;
    @XmlElement(name = "Language")
    protected MessageHeader.Language language;
    @XmlElement(name = "Correlation")
    protected MessageHeader.Correlation correlation;
    @XmlElement(name = "PointOfSale", required = true)
    protected List<MessageHeader.PointOfSale> pointOfSale;
    @XmlElement(name = "Results")
    protected MessageHeader.Results results;

    /**
     * Gets the value of the identification property.
     * 
     * @return
     *     possible object is
     *     {@link MessageHeader.Identification }
     *     
     */
    public MessageHeader.Identification getIdentification() {
        return identification;
    }

    /**
     * Sets the value of the identification property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageHeader.Identification }
     *     
     */
    public void setIdentification(MessageHeader.Identification value) {
        this.identification = value;
    }

    /**
     * Gets the value of the targetSystem property.
     * 
     * @return
     *     possible object is
     *     {@link MessageHeader.TargetSystem }
     *     
     */
    public MessageHeader.TargetSystem getTargetSystem() {
        return targetSystem;
    }

    /**
     * Sets the value of the targetSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageHeader.TargetSystem }
     *     
     */
    public void setTargetSystem(MessageHeader.TargetSystem value) {
        this.targetSystem = value;
    }

    /**
     * Gets the value of the language property.
     * 
     * @return
     *     possible object is
     *     {@link MessageHeader.Language }
     *     
     */
    public MessageHeader.Language getLanguage() {
        return language;
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageHeader.Language }
     *     
     */
    public void setLanguage(MessageHeader.Language value) {
        this.language = value;
    }

    /**
     * Gets the value of the correlation property.
     * 
     * @return
     *     possible object is
     *     {@link MessageHeader.Correlation }
     *     
     */
    public MessageHeader.Correlation getCorrelation() {
        return correlation;
    }

    /**
     * Sets the value of the correlation property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageHeader.Correlation }
     *     
     */
    public void setCorrelation(MessageHeader.Correlation value) {
        this.correlation = value;
    }

    /**
     * Gets the value of the pointOfSale property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the pointOfSale property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPointOfSale().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MessageHeader.PointOfSale }
     * 
     * 
     */
    public List<MessageHeader.PointOfSale> getPointOfSale() {
        if (pointOfSale == null) {
            pointOfSale = new ArrayList<MessageHeader.PointOfSale>();
        }
        return this.pointOfSale;
    }

    /**
     * Gets the value of the results property.
     * 
     * @return
     *     possible object is
     *     {@link MessageHeader.Results }
     *     
     */
    public MessageHeader.Results getResults() {
        return results;
    }

    /**
     * Sets the value of the results property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageHeader.Results }
     *     
     */
    public void setResults(MessageHeader.Results value) {
        this.results = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Correlation
        implements Serializable
    {


    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="timeStamp" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
     *       &lt;attribute name="messageID" type="{http://opentravel.org/common/v02}String_Short" />
     *       &lt;attribute name="correlationID" type="{http://opentravel.org/common/v02}String_Medium" />
     *       &lt;attribute name="sequenceNbr" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Identification
        implements Serializable
    {

        @XmlAttribute(name = "timeStamp", required = true)
        @XmlSchemaType(name = "dateTime")
        protected XMLGregorianCalendar timeStamp;
        @XmlAttribute(name = "messageID")
        protected String messageID;
        @XmlAttribute(name = "correlationID")
        protected String correlationID;
        @XmlAttribute(name = "sequenceNbr")
        @XmlSchemaType(name = "nonNegativeInteger")
        protected BigInteger sequenceNbr;

        /**
         * Gets the value of the timeStamp property.
         * 
         * @return
         *     possible object is
         *     {@link XMLGregorianCalendar }
         *     
         */
        public XMLGregorianCalendar getTimeStamp() {
            return timeStamp;
        }

        /**
         * Sets the value of the timeStamp property.
         * 
         * @param value
         *     allowed object is
         *     {@link XMLGregorianCalendar }
         *     
         */
        public void setTimeStamp(XMLGregorianCalendar value) {
            this.timeStamp = value;
        }

        /**
         * Gets the value of the messageID property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getMessageID() {
            return messageID;
        }

        /**
         * Sets the value of the messageID property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setMessageID(String value) {
            this.messageID = value;
        }

        /**
         * Gets the value of the correlationID property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getCorrelationID() {
            return correlationID;
        }

        /**
         * Sets the value of the correlationID property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setCorrelationID(String value) {
            this.correlationID = value;
        }

        /**
         * Gets the value of the sequenceNbr property.
         * 
         * @return
         *     possible object is
         *     {@link BigInteger }
         *     
         */
        public BigInteger getSequenceNbr() {
            return sequenceNbr;
        }

        /**
         * Sets the value of the sequenceNbr property.
         * 
         * @param value
         *     allowed object is
         *     {@link BigInteger }
         *     
         */
        public void setSequenceNbr(BigInteger value) {
            this.sequenceNbr = value;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="primary" type="{http://www.w3.org/2001/XMLSchema}language" />
     *       &lt;attribute name="secondary" type="{http://www.w3.org/2001/XMLSchema}language" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Language
        implements Serializable
    {

        @XmlAttribute(name = "primary")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        @XmlSchemaType(name = "language")
        protected String primary;
        @XmlAttribute(name = "secondary")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        @XmlSchemaType(name = "language")
        protected String secondary;

        /**
         * Gets the value of the primary property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPrimary() {
            return primary;
        }

        /**
         * Sets the value of the primary property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setPrimary(String value) {
            this.primary = value;
        }

        /**
         * Gets the value of the secondary property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getSecondary() {
            return secondary;
        }

        /**
         * Sets the value of the secondary property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setSecondary(String value) {
            this.secondary = value;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;sequence>
     *         &lt;element name="Type">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="Company" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *         &lt;element name="BookingChannelInfo" minOccurs="0">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;sequence minOccurs="0">
     *                   &lt;element name="Type">
     *                     &lt;complexType>
     *                       &lt;simpleContent>
     *                         &lt;extension base="&lt;http://opentravel.org/common/v02>Enum_BookingChannel_Base">
     *                           &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
     *                         &lt;/extension>
     *                       &lt;/simpleContent>
     *                     &lt;/complexType>
     *                   &lt;/element>
     *                   &lt;element name="Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *                 &lt;/sequence>
     *                 &lt;attribute name="primaryInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
     *                 &lt;attribute name="id" type="{http://opentravel.org/common/v02}String_Short" />
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="Agent" minOccurs="0">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;attribute name="sine" type="{http://opentravel.org/common/v02}String_Short" />
     *                 &lt;attribute name="pseudoCityCode" type="{http://opentravel.org/common/v02}Code_PseudoCity" />
     *                 &lt;attribute name="dutyCode" type="{http://opentravel.org/common/v02}Code_AgentDuty" />
     *                 &lt;attribute name="terminalID" type="{http://opentravel.org/common/v02}String_Short" />
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="AirInfo" minOccurs="0">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;attribute name="ERSP" type="{http://opentravel.org/common/v02}Code_IATA_ERSP" />
     *                 &lt;attribute name="airlineVendorID" type="{http://opentravel.org/common/v02}Code_IATA_AirlineID" />
     *                 &lt;attribute name="airportCode" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" />
     *                 &lt;attribute name="firstDeparturePoint" type="{http://opentravel.org/common/v02}Code_IATA_Airport" />
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="Location" minOccurs="0">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;sequence>
     *                   &lt;element name="TimeZone" type="{http://opentravel.org/common/v02}TimeZone" minOccurs="0"/>
     *                 &lt;/sequence>
     *                 &lt;attribute name="ISOCountry" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" />
     *                 &lt;attribute name="ISOCurrency" type="{http://opentravel.org/common/v02}Code_ISO_Currency" />
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="Position" type="{http://opentravel.org/common/v02}String_Short" minOccurs="0"/>
     *       &lt;/sequence>
     *       &lt;attribute name="requestorID" use="required" type="{http://opentravel.org/common/v02}String_Short" />
     *       &lt;attribute name="idContext" type="{http://opentravel.org/common/v02}String_Short" />
     *       &lt;attribute name="url" type="{http://opentravel.org/common/v02}URL" />
     *       &lt;attribute name="travelSegment" type="{http://opentravel.org/common/v02}Enum_TravelSector_Base" />
     *       &lt;attribute name="messagePassword" type="{http://opentravel.org/common/v02}String_Short" />
     *       &lt;attribute name="domain" type="{http://opentravel.org/common/v02}String_Short" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "type",
        "company",
        "bookingChannelInfo",
        "agent",
        "airInfo",
        "location",
        "position"
    })
    public static class PointOfSale
        implements Serializable
    {

        @XmlElement(name = "Type", required = true)
        protected MessageHeader.PointOfSale.Type type;
        @XmlElement(name = "Company")
        protected String company;
        @XmlElement(name = "BookingChannelInfo")
        protected MessageHeader.PointOfSale.BookingChannelInfo bookingChannelInfo;
        @XmlElement(name = "Agent")
        protected MessageHeader.PointOfSale.Agent agent;
        @XmlElement(name = "AirInfo")
        protected MessageHeader.PointOfSale.AirInfo airInfo;
        @XmlElement(name = "Location")
        protected MessageHeader.PointOfSale.Location location;
        @XmlElement(name = "Position")
        protected String position;
        @XmlAttribute(name = "requestorID", required = true)
        protected String requestorID;
        @XmlAttribute(name = "idContext")
        protected String idContext;
        @XmlAttribute(name = "url")
        protected String url;
        @XmlAttribute(name = "travelSegment")
        protected EnumTravelSectorBase travelSegment;
        @XmlAttribute(name = "messagePassword")
        protected String messagePassword;
        @XmlAttribute(name = "domain")
        protected String domain;

        /**
         * Gets the value of the type property.
         * 
         * @return
         *     possible object is
         *     {@link MessageHeader.PointOfSale.Type }
         *     
         */
        public MessageHeader.PointOfSale.Type getType() {
            return type;
        }

        /**
         * Sets the value of the type property.
         * 
         * @param value
         *     allowed object is
         *     {@link MessageHeader.PointOfSale.Type }
         *     
         */
        public void setType(MessageHeader.PointOfSale.Type value) {
            this.type = value;
        }

        /**
         * Gets the value of the company property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getCompany() {
            return company;
        }

        /**
         * Sets the value of the company property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setCompany(String value) {
            this.company = value;
        }

        /**
         * Gets the value of the bookingChannelInfo property.
         * 
         * @return
         *     possible object is
         *     {@link MessageHeader.PointOfSale.BookingChannelInfo }
         *     
         */
        public MessageHeader.PointOfSale.BookingChannelInfo getBookingChannelInfo() {
            return bookingChannelInfo;
        }

        /**
         * Sets the value of the bookingChannelInfo property.
         * 
         * @param value
         *     allowed object is
         *     {@link MessageHeader.PointOfSale.BookingChannelInfo }
         *     
         */
        public void setBookingChannelInfo(MessageHeader.PointOfSale.BookingChannelInfo value) {
            this.bookingChannelInfo = value;
        }

        /**
         * Gets the value of the agent property.
         * 
         * @return
         *     possible object is
         *     {@link MessageHeader.PointOfSale.Agent }
         *     
         */
        public MessageHeader.PointOfSale.Agent getAgent() {
            return agent;
        }

        /**
         * Sets the value of the agent property.
         * 
         * @param value
         *     allowed object is
         *     {@link MessageHeader.PointOfSale.Agent }
         *     
         */
        public void setAgent(MessageHeader.PointOfSale.Agent value) {
            this.agent = value;
        }

        /**
         * Gets the value of the airInfo property.
         * 
         * @return
         *     possible object is
         *     {@link MessageHeader.PointOfSale.AirInfo }
         *     
         */
        public MessageHeader.PointOfSale.AirInfo getAirInfo() {
            return airInfo;
        }

        /**
         * Sets the value of the airInfo property.
         * 
         * @param value
         *     allowed object is
         *     {@link MessageHeader.PointOfSale.AirInfo }
         *     
         */
        public void setAirInfo(MessageHeader.PointOfSale.AirInfo value) {
            this.airInfo = value;
        }

        /**
         * Gets the value of the location property.
         * 
         * @return
         *     possible object is
         *     {@link MessageHeader.PointOfSale.Location }
         *     
         */
        public MessageHeader.PointOfSale.Location getLocation() {
            return location;
        }

        /**
         * Sets the value of the location property.
         * 
         * @param value
         *     allowed object is
         *     {@link MessageHeader.PointOfSale.Location }
         *     
         */
        public void setLocation(MessageHeader.PointOfSale.Location value) {
            this.location = value;
        }

        /**
         * Gets the value of the position property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPosition() {
            return position;
        }

        /**
         * Sets the value of the position property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setPosition(String value) {
            this.position = value;
        }

        /**
         * Gets the value of the requestorID property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getRequestorID() {
            return requestorID;
        }

        /**
         * Sets the value of the requestorID property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setRequestorID(String value) {
            this.requestorID = value;
        }

        /**
         * Gets the value of the idContext property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getIdContext() {
            return idContext;
        }

        /**
         * Sets the value of the idContext property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setIdContext(String value) {
            this.idContext = value;
        }

        /**
         * Gets the value of the url property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getUrl() {
            return url;
        }

        /**
         * Sets the value of the url property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setUrl(String value) {
            this.url = value;
        }

        /**
         * Gets the value of the travelSegment property.
         * 
         * @return
         *     possible object is
         *     {@link EnumTravelSectorBase }
         *     
         */
        public EnumTravelSectorBase getTravelSegment() {
            return travelSegment;
        }

        /**
         * Sets the value of the travelSegment property.
         * 
         * @param value
         *     allowed object is
         *     {@link EnumTravelSectorBase }
         *     
         */
        public void setTravelSegment(EnumTravelSectorBase value) {
            this.travelSegment = value;
        }

        /**
         * Gets the value of the messagePassword property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getMessagePassword() {
            return messagePassword;
        }

        /**
         * Sets the value of the messagePassword property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setMessagePassword(String value) {
            this.messagePassword = value;
        }

        /**
         * Gets the value of the domain property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getDomain() {
            return domain;
        }

        /**
         * Sets the value of the domain property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setDomain(String value) {
            this.domain = value;
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;attribute name="sine" type="{http://opentravel.org/common/v02}String_Short" />
         *       &lt;attribute name="pseudoCityCode" type="{http://opentravel.org/common/v02}Code_PseudoCity" />
         *       &lt;attribute name="dutyCode" type="{http://opentravel.org/common/v02}Code_AgentDuty" />
         *       &lt;attribute name="terminalID" type="{http://opentravel.org/common/v02}String_Short" />
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "")
        public static class Agent
            implements Serializable
        {

            @XmlAttribute(name = "sine")
            protected String sine;
            @XmlAttribute(name = "pseudoCityCode")
            protected String pseudoCityCode;
            @XmlAttribute(name = "dutyCode")
            protected String dutyCode;
            @XmlAttribute(name = "terminalID")
            protected String terminalID;

            /**
             * Gets the value of the sine property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getSine() {
                return sine;
            }

            /**
             * Sets the value of the sine property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setSine(String value) {
                this.sine = value;
            }

            /**
             * Gets the value of the pseudoCityCode property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getPseudoCityCode() {
                return pseudoCityCode;
            }

            /**
             * Sets the value of the pseudoCityCode property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setPseudoCityCode(String value) {
                this.pseudoCityCode = value;
            }

            /**
             * Gets the value of the dutyCode property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getDutyCode() {
                return dutyCode;
            }

            /**
             * Sets the value of the dutyCode property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setDutyCode(String value) {
                this.dutyCode = value;
            }

            /**
             * Gets the value of the terminalID property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getTerminalID() {
                return terminalID;
            }

            /**
             * Sets the value of the terminalID property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setTerminalID(String value) {
                this.terminalID = value;
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;attribute name="ERSP" type="{http://opentravel.org/common/v02}Code_IATA_ERSP" />
         *       &lt;attribute name="airlineVendorID" type="{http://opentravel.org/common/v02}Code_IATA_AirlineID" />
         *       &lt;attribute name="airportCode" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" />
         *       &lt;attribute name="firstDeparturePoint" type="{http://opentravel.org/common/v02}Code_IATA_Airport" />
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "")
        public static class AirInfo
            implements Serializable
        {

            @XmlAttribute(name = "ERSP")
            protected String ersp;
            @XmlAttribute(name = "airlineVendorID")
            protected String airlineVendorID;
            @XmlAttribute(name = "airportCode")
            @XmlSchemaType(name = "anySimpleType")
            protected String airportCode;
            @XmlAttribute(name = "firstDeparturePoint")
            protected String firstDeparturePoint;

            /**
             * Gets the value of the ersp property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getERSP() {
                return ersp;
            }

            /**
             * Sets the value of the ersp property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setERSP(String value) {
                this.ersp = value;
            }

            /**
             * Gets the value of the airlineVendorID property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getAirlineVendorID() {
                return airlineVendorID;
            }

            /**
             * Sets the value of the airlineVendorID property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setAirlineVendorID(String value) {
                this.airlineVendorID = value;
            }

            /**
             * Gets the value of the airportCode property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getAirportCode() {
                return airportCode;
            }

            /**
             * Sets the value of the airportCode property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setAirportCode(String value) {
                this.airportCode = value;
            }

            /**
             * Gets the value of the firstDeparturePoint property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getFirstDeparturePoint() {
                return firstDeparturePoint;
            }

            /**
             * Sets the value of the firstDeparturePoint property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setFirstDeparturePoint(String value) {
                this.firstDeparturePoint = value;
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;sequence minOccurs="0">
         *         &lt;element name="Type">
         *           &lt;complexType>
         *             &lt;simpleContent>
         *               &lt;extension base="&lt;http://opentravel.org/common/v02>Enum_BookingChannel_Base">
         *                 &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
         *               &lt;/extension>
         *             &lt;/simpleContent>
         *           &lt;/complexType>
         *         &lt;/element>
         *         &lt;element name="Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
         *       &lt;/sequence>
         *       &lt;attribute name="primaryInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
         *       &lt;attribute name="id" type="{http://opentravel.org/common/v02}String_Short" />
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "type",
            "name"
        })
        public static class BookingChannelInfo
            implements Serializable
        {

            @XmlElement(name = "Type")
            protected MessageHeader.PointOfSale.BookingChannelInfo.Type type;
            @XmlElement(name = "Name")
            protected String name;
            @XmlAttribute(name = "primaryInd")
            protected Boolean primaryInd;
            @XmlAttribute(name = "id")
            protected String id;

            /**
             * Gets the value of the type property.
             * 
             * @return
             *     possible object is
             *     {@link MessageHeader.PointOfSale.BookingChannelInfo.Type }
             *     
             */
            public MessageHeader.PointOfSale.BookingChannelInfo.Type getType() {
                return type;
            }

            /**
             * Sets the value of the type property.
             * 
             * @param value
             *     allowed object is
             *     {@link MessageHeader.PointOfSale.BookingChannelInfo.Type }
             *     
             */
            public void setType(MessageHeader.PointOfSale.BookingChannelInfo.Type value) {
                this.type = value;
            }

            /**
             * Gets the value of the name property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getName() {
                return name;
            }

            /**
             * Sets the value of the name property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setName(String value) {
                this.name = value;
            }

            /**
             * Gets the value of the primaryInd property.
             * 
             * @return
             *     possible object is
             *     {@link Boolean }
             *     
             */
            public Boolean getPrimaryInd() {
                return primaryInd;
            }

            /**
             * Sets the value of the primaryInd property.
             * 
             * @param value
             *     allowed object is
             *     {@link Boolean }
             *     
             */
            public void setPrimaryInd(Boolean value) {
                this.primaryInd = value;
            }

            /**
             * Gets the value of the id property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getId() {
                return id;
            }

            /**
             * Sets the value of the id property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setId(String value) {
                this.id = value;
            }


            /**
             * <p>Java class for anonymous complex type.
             * 
             * <p>The following schema fragment specifies the expected content contained within this class.
             * 
             * <pre>
             * &lt;complexType>
             *   &lt;simpleContent>
             *     &lt;extension base="&lt;http://opentravel.org/common/v02>Enum_BookingChannel_Base">
             *       &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
             *     &lt;/extension>
             *   &lt;/simpleContent>
             * &lt;/complexType>
             * </pre>
             * 
             * 
             */
            @XmlAccessorType(XmlAccessType.FIELD)
            @XmlType(name = "", propOrder = {
                "value"
            })
            public static class Type
                implements Serializable
            {

                @XmlValue
                protected EnumBookingChannelBase value;
                @XmlAttribute(name = "extension")
                protected String extension;

                /**
                 * Booking Channel Type (BCT)
                 * 
                 * @return
                 *     possible object is
                 *     {@link EnumBookingChannelBase }
                 *     
                 */
                public EnumBookingChannelBase getValue() {
                    return value;
                }

                /**
                 * Sets the value of the value property.
                 * 
                 * @param value
                 *     allowed object is
                 *     {@link EnumBookingChannelBase }
                 *     
                 */
                public void setValue(EnumBookingChannelBase value) {
                    this.value = value;
                }

                /**
                 * Gets the value of the extension property.
                 * 
                 * @return
                 *     possible object is
                 *     {@link String }
                 *     
                 */
                public String getExtension() {
                    return extension;
                }

                /**
                 * Sets the value of the extension property.
                 * 
                 * @param value
                 *     allowed object is
                 *     {@link String }
                 *     
                 */
                public void setExtension(String value) {
                    this.extension = value;
                }

            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;sequence>
         *         &lt;element name="TimeZone" type="{http://opentravel.org/common/v02}TimeZone" minOccurs="0"/>
         *       &lt;/sequence>
         *       &lt;attribute name="ISOCountry" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" />
         *       &lt;attribute name="ISOCurrency" type="{http://opentravel.org/common/v02}Code_ISO_Currency" />
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "timeZone"
        })
        public static class Location
            implements Serializable
        {

            @XmlElement(name = "TimeZone")
            protected TimeZone timeZone;
            @XmlAttribute(name = "ISOCountry")
            @XmlSchemaType(name = "anySimpleType")
            protected String isoCountry;
            @XmlAttribute(name = "ISOCurrency")
            protected String isoCurrency;

            /**
             * Gets the value of the timeZone property.
             * 
             * @return
             *     possible object is
             *     {@link TimeZone }
             *     
             */
            public TimeZone getTimeZone() {
                return timeZone;
            }

            /**
             * Sets the value of the timeZone property.
             * 
             * @param value
             *     allowed object is
             *     {@link TimeZone }
             *     
             */
            public void setTimeZone(TimeZone value) {
                this.timeZone = value;
            }

            /**
             * Gets the value of the isoCountry property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getISOCountry() {
                return isoCountry;
            }

            /**
             * Sets the value of the isoCountry property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setISOCountry(String value) {
                this.isoCountry = value;
            }

            /**
             * Gets the value of the isoCurrency property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getISOCurrency() {
                return isoCurrency;
            }

            /**
             * Sets the value of the isoCurrency property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setISOCurrency(String value) {
                this.isoCurrency = value;
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;attribute name="extension" type="{http://opentravel.org/common/v02}String_EnumExtension" />
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "")
        public static class Type
            implements Serializable
        {

            @XmlAttribute(name = "extension")
            protected String extension;

            /**
             * Gets the value of the extension property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getExtension() {
                return extension;
            }

            /**
             * Sets the value of the extension property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setExtension(String value) {
                this.extension = value;
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="failureInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
     *       &lt;attribute name="status" use="required">
     *         &lt;simpleType>
     *           &lt;restriction base="{http://opentravel.org/common/message/v02}Enum_ProcessingStatus">
     *           &lt;/restriction>
     *         &lt;/simpleType>
     *       &lt;/attribute>
     *       &lt;attribute name="retryInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
     *       &lt;attribute name="compensationInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Results
        implements Serializable
    {

        @XmlAttribute(name = "failureInd")
        protected Boolean failureInd;
        @XmlAttribute(name = "status", required = true)
        protected EnumProcessingStatus status;
        @XmlAttribute(name = "retryInd")
        protected Boolean retryInd;
        @XmlAttribute(name = "compensationInd")
        protected Boolean compensationInd;

        /**
         * Gets the value of the failureInd property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public Boolean getFailureInd() {
            return failureInd;
        }

        /**
         * Sets the value of the failureInd property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setFailureInd(Boolean value) {
            this.failureInd = value;
        }

        /**
         * Gets the value of the status property.
         * 
         * @return
         *     possible object is
         *     {@link EnumProcessingStatus }
         *     
         */
        public EnumProcessingStatus getStatus() {
            return status;
        }

        /**
         * Sets the value of the status property.
         * 
         * @param value
         *     allowed object is
         *     {@link EnumProcessingStatus }
         *     
         */
        public void setStatus(EnumProcessingStatus value) {
            this.status = value;
        }

        /**
         * Gets the value of the retryInd property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public Boolean getRetryInd() {
            return retryInd;
        }

        /**
         * Sets the value of the retryInd property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setRetryInd(Boolean value) {
            this.retryInd = value;
        }

        /**
         * Gets the value of the compensationInd property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public Boolean getCompensationInd() {
            return compensationInd;
        }

        /**
         * Sets the value of the compensationInd property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setCompensationInd(Boolean value) {
            this.compensationInd = value;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="type">
     *         &lt;simpleType>
     *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
     *             &lt;enumeration value="Production"/>
     *             &lt;enumeration value="Test"/>
     *           &lt;/restriction>
     *         &lt;/simpleType>
     *       &lt;/attribute>
     *       &lt;attribute name="name" type="{http://opentravel.org/common/v02}String_Short" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class TargetSystem
        implements Serializable
    {

        @XmlAttribute(name = "type")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        protected String type;
        @XmlAttribute(name = "name")
        protected String name;

        /**
         * Gets the value of the type property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getType() {
            return type;
        }

        /**
         * Sets the value of the type property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setType(String value) {
            this.type = value;
        }

        /**
         * Gets the value of the name property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getName() {
            return name;
        }

        /**
         * Sets the value of the name property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setName(String value) {
            this.name = value;
        }

    }

}
