
package com.gridnine.sabre.jaxws.stl2.buildinmodel;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.gridnine.sabre.jaxws.ota2.message.ExtensionPoint;


/**
 * Describes loyalty level, whether it is atpco level code, sabre code, ot vendor specified.
 * 
 * <p>Java class for Loyalty complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Loyalty">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="TravelSector" type="{http://services.sabre.com/STL/v02}Enum_TravelSector" minOccurs="0"/>
 *         &lt;element name="Vendor" type="{http://services.sabre.com/STL/v02}Code_Vendor" minOccurs="0"/>
 *         &lt;element name="Level" type="{http://services.sabre.com/STL/v02}Loyalty_Level"/>
 *         &lt;element ref="{http://opentravel.org/common/message/v02}ExtensionPoint_Summary" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Loyalty", propOrder = {
    "travelSector",
    "vendor",
    "level",
    "extensionPointSummary"
})
@XmlSeeAlso({
    LoyaltyDetail.class
})
public class Loyalty implements Serializable
{

    @XmlElement(name = "TravelSector")
    protected EnumTravelSector travelSector;
    @XmlElement(name = "Vendor")
    protected String vendor;
    @XmlElement(name = "Level", required = true)
    protected LoyaltyLevel level;
    @XmlElement(name = "ExtensionPoint_Summary", namespace = "http://opentravel.org/common/message/v02")
    protected ExtensionPoint extensionPointSummary;

    /**
     * Gets the value of the travelSector property.
     * 
     * @return
     *     possible object is
     *     {@link EnumTravelSector }
     *     
     */
    public EnumTravelSector getTravelSector() {
        return travelSector;
    }

    /**
     * Sets the value of the travelSector property.
     * 
     * @param value
     *     allowed object is
     *     {@link EnumTravelSector }
     *     
     */
    public void setTravelSector(EnumTravelSector value) {
        this.travelSector = value;
    }

    /**
     * Gets the value of the vendor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVendor() {
        return vendor;
    }

    /**
     * Sets the value of the vendor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVendor(String value) {
        this.vendor = value;
    }

    /**
     * Gets the value of the level property.
     * 
     * @return
     *     possible object is
     *     {@link LoyaltyLevel }
     *     
     */
    public LoyaltyLevel getLevel() {
        return level;
    }

    /**
     * Sets the value of the level property.
     * 
     * @param value
     *     allowed object is
     *     {@link LoyaltyLevel }
     *     
     */
    public void setLevel(LoyaltyLevel value) {
        this.level = value;
    }

    /**
     * Gets the value of the extensionPointSummary property.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionPoint }
     *     
     */
    public ExtensionPoint getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /**
     * Sets the value of the extensionPointSummary property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionPoint }
     *     
     */
    public void setExtensionPointSummary(ExtensionPoint value) {
        this.extensionPointSummary = value;
    }

}
