
package com.sabre.services.merch.fare.v03;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * Defines air fare attributes like fare basis code.
 * 
 * <p>Java class for FareInfo complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="FareInfo">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="FareComponentID" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         &lt;element name="GoverningCarrier" type="{http://services.sabre.com/merch/common/v03}Code_Airline" minOccurs="0"/>
 *         &lt;element name="FareAmount" type="{http://services.sabre.com/merch/common/v03}Amount" minOccurs="0"/>
 *         &lt;element name="FareBasisCode" type="{http://services.sabre.com/merch/common/v03}String_Short" minOccurs="0"/>
 *         &lt;element name="FareType" type="{http://services.sabre.com/merch/common/v03}UpperCaseAlphaLength1to3" minOccurs="0"/>
 *         &lt;element name="ATPCO_FareTariff" type="{http://www.w3.org/2001/XMLSchema}short" minOccurs="0"/>
 *         &lt;element name="ATPCO_FareRule" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="FareIndicator" type="{http://www.w3.org/2001/XMLSchema}byte" minOccurs="0"/>
 *         &lt;element name="PrivateTariffIndicator" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="FareTypeBitmap" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="FareVendorCode" type="{http://services.sabre.com/merch/common/v03}Code_Vendor" minOccurs="0"/>
 *         &lt;element name="Brand" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FareInfo", propOrder = {
    "fareComponentID",
    "governingCarrier",
    "fareAmount",
    "fareBasisCode",
    "fareType",
    "atpcoFareTariff",
    "atpcoFareRule",
    "fareIndicator",
    "privateTariffIndicator",
    "fareTypeBitmap",
    "fareVendorCode",
    "brand"
})
public class FareInfo
    implements Serializable
{

    @XmlElement(name = "FareComponentID")
    protected Integer fareComponentID;
    @XmlElement(name = "GoverningCarrier")
    protected String governingCarrier;
    @XmlElement(name = "FareAmount")
    protected BigDecimal fareAmount;
    @XmlElement(name = "FareBasisCode")
    protected String fareBasisCode;
    @XmlElement(name = "FareType")
    protected String fareType;
    @XmlElement(name = "ATPCO_FareTariff")
    protected Short atpcoFareTariff;
    @XmlElement(name = "ATPCO_FareRule")
    protected String atpcoFareRule;
    @XmlElement(name = "FareIndicator")
    protected Byte fareIndicator;
    @XmlElement(name = "PrivateTariffIndicator")
    protected Boolean privateTariffIndicator;
    @XmlElement(name = "FareTypeBitmap")
    protected String fareTypeBitmap;
    @XmlElement(name = "FareVendorCode")
    protected String fareVendorCode;
    @XmlElement(name = "Brand")
    protected String brand;
    @XmlAttribute(name = "id", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;

    /**
     * Gets the value of the fareComponentID property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getFareComponentID() {
        return fareComponentID;
    }

    /**
     * Sets the value of the fareComponentID property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setFareComponentID(Integer value) {
        this.fareComponentID = value;
    }

    /**
     * Gets the value of the governingCarrier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGoverningCarrier() {
        return governingCarrier;
    }

    /**
     * Sets the value of the governingCarrier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGoverningCarrier(String value) {
        this.governingCarrier = value;
    }

    /**
     * Gets the value of the fareAmount property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getFareAmount() {
        return fareAmount;
    }

    /**
     * Sets the value of the fareAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setFareAmount(BigDecimal value) {
        this.fareAmount = value;
    }

    /**
     * Gets the value of the fareBasisCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /**
     * Sets the value of the fareBasisCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFareBasisCode(String value) {
        this.fareBasisCode = value;
    }

    /**
     * Gets the value of the fareType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFareType() {
        return fareType;
    }

    /**
     * Sets the value of the fareType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFareType(String value) {
        this.fareType = value;
    }

    /**
     * Gets the value of the atpcoFareTariff property.
     * 
     * @return
     *     possible object is
     *     {@link Short }
     *     
     */
    public Short getATPCOFareTariff() {
        return atpcoFareTariff;
    }

    /**
     * Sets the value of the atpcoFareTariff property.
     * 
     * @param value
     *     allowed object is
     *     {@link Short }
     *     
     */
    public void setATPCOFareTariff(Short value) {
        this.atpcoFareTariff = value;
    }

    /**
     * Gets the value of the atpcoFareRule property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getATPCOFareRule() {
        return atpcoFareRule;
    }

    /**
     * Sets the value of the atpcoFareRule property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setATPCOFareRule(String value) {
        this.atpcoFareRule = value;
    }

    /**
     * Gets the value of the fareIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Byte }
     *     
     */
    public Byte getFareIndicator() {
        return fareIndicator;
    }

    /**
     * Sets the value of the fareIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Byte }
     *     
     */
    public void setFareIndicator(Byte value) {
        this.fareIndicator = value;
    }

    /**
     * Gets the value of the privateTariffIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getPrivateTariffIndicator() {
        return privateTariffIndicator;
    }

    /**
     * Sets the value of the privateTariffIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrivateTariffIndicator(Boolean value) {
        this.privateTariffIndicator = value;
    }

    /**
     * Gets the value of the fareTypeBitmap property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFareTypeBitmap() {
        return fareTypeBitmap;
    }

    /**
     * Sets the value of the fareTypeBitmap property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFareTypeBitmap(String value) {
        this.fareTypeBitmap = value;
    }

    /**
     * Gets the value of the fareVendorCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFareVendorCode() {
        return fareVendorCode;
    }

    /**
     * Sets the value of the fareVendorCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFareVendorCode(String value) {
        this.fareVendorCode = value;
    }

    /**
     * Gets the value of the brand property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBrand() {
        return brand;
    }

    /**
     * Sets the value of the brand property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBrand(String value) {
        this.brand = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

}
