
package com.sabre.services.merch.products.v03;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Enum_AncillaryBookingMethod.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="Enum_AncillaryBookingMethod">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="SPECIAL_SERVICE_REQUEST"/>
 *     &lt;enumeration value="AUXILIARY_SEGMENT"/>
 *     &lt;enumeration value="CONTACT_AIRLINE"/>
 *     &lt;enumeration value="NO_BOOKING_REQUIRED"/>
 *     &lt;enumeration value="PER_SERVICE_RECORD"/>
 *     &lt;enumeration value="ANY_ALLOWED"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Enum_AncillaryBookingMethod")
@XmlEnum
public enum EnumAncillaryBookingMethod {


    /**
     * 
     *                         Maps to value 01 of booking field in S5 record specification.
     *                         The service identified by the sub code in this record must be booked via SSR messaging.
     *                     
     * 
     */
    SPECIAL_SERVICE_REQUEST,

    /**
     * 
     *                         Maps to value 02 of booking field in S5 record specification - 'auxiliary segment'.
     *                         The service identified by the sub code in this record may be booked via an auxiliary segment.
     *                     
     * 
     */
    AUXILIARY_SEGMENT,

    /**
     * 
     *                         Maps to value 03 of booking field in S5 record specification - 'available for display and/or
     *                         pricing'. The service identified by the sub code is available for display and/or pricing.
     *                         The carrier must be contacted for the applicable booking details.
     *                     
     * 
     */
    CONTACT_AIRLINE,

    /**
     * 
     *                         Maps to value 04 of booking field in S5 record specification - 'no booking required'.
     *                         The service identified by the sub code is available for display and/or pricing.
     *                         There is no booking required for the specified service.
     *                     
     * 
     */
    NO_BOOKING_REQUIRED,

    /**
     * 
     *                         Maps to value 05 of booking field in S5 record specification - 'apply booking method per service
     *                         record'. The service identified by the sub code is a bundled service.
     *                     
     * 
     */
    PER_SERVICE_RECORD,

    /**
     * 
     *                         Maps to value blank of booking field in S5 record specification.
     *                         Any booking method is allowed.
     *                     
     * 
     */
    ANY_ALLOWED;

    public String value() {
        return name();
    }

    public static EnumAncillaryBookingMethod fromValue(String v) {
        return valueOf(v);
    }

}
