
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfoExchangeAttributeGroup">
 *   &lt;xs:attribute type="xs:date" name="PreviousExchangeDate"/>
 *   &lt;xs:attribute name="ReissueExchange">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class ReissueExchange -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:date" name="AdvancedPurchaseDate"/>
 *   &lt;xs:attribute type="xs:date" name="PurchaseByDate"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AirItineraryPricingInfoExchangeAttributeGroup implements
    Serializable
{
    private Date previousExchangeDate;
    private ReissueExchange reissueExchange;
    private Date advancedPurchaseDate;
    private Date purchaseByDate;

    /** 
     * Get the 'PreviousExchangeDate' attribute value. Previous Exchange Date
     * 
     * @return value
     */
    public Date getPreviousExchangeDate() {
        return previousExchangeDate;
    }

    /** 
     * Set the 'PreviousExchangeDate' attribute value. Previous Exchange Date
     * 
     * @param previousExchangeDate
     */
    public void setPreviousExchangeDate(Date previousExchangeDate) {
        this.previousExchangeDate = previousExchangeDate;
    }

    /** 
     * Get the 'ReissueExchange' attribute value. Indicates whether priced as Reissue or Exchange
     * 
     * @return value
     */
    public ReissueExchange getReissueExchange() {
        return reissueExchange;
    }

    /** 
     * Set the 'ReissueExchange' attribute value. Indicates whether priced as Reissue or Exchange
     * 
     * @param reissueExchange
     */
    public void setReissueExchange(ReissueExchange reissueExchange) {
        this.reissueExchange = reissueExchange;
    }

    /** 
     * Get the 'AdvancedPurchaseDate' attribute value.
     * 
     * @return value
     */
    public Date getAdvancedPurchaseDate() {
        return advancedPurchaseDate;
    }

    /** 
     * Set the 'AdvancedPurchaseDate' attribute value.
     * 
     * @param advancedPurchaseDate
     */
    public void setAdvancedPurchaseDate(Date advancedPurchaseDate) {
        this.advancedPurchaseDate = advancedPurchaseDate;
    }

    /** 
     * Get the 'PurchaseByDate' attribute value.
     * 
     * @return value
     */
    public Date getPurchaseByDate() {
        return purchaseByDate;
    }

    /** 
     * Set the 'PurchaseByDate' attribute value.
     * 
     * @param purchaseByDate
     */
    public void setPurchaseByDate(Date purchaseByDate) {
        this.purchaseByDate = purchaseByDate;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:int">
     *     &lt;xs:enumeration value="1"/>
     *     &lt;xs:enumeration value="2"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ReissueExchange implements Serializable {
        /** 
         * Priced as Reissue
         */
        _1("1"), /** 
                  * Priced as Exchange
                  */
        _2("2");
        private final String value;

        private ReissueExchange(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static ReissueExchange convert(String value) {
            for (ReissueExchange inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
