
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Pricing Information for an Air Itinerary
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryPricingInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Offer" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class Offer -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:ItinTotalFareType" name="ItinTotalFare" minOccurs="0"/>
 *     &lt;xs:element name="PTC_FareBreakdowns" minOccurs="0">
 *       &lt;!-- Reference to inner class PTCFareBreakdowns -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareInfos" minOccurs="0">
 *       &lt;!-- Reference to inner class FareInfos -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:FareSourceAndTypeAttributes"/>
 *   &lt;xs:attribute type="xs:string" name="LastTicketDate"/>
 *   &lt;xs:attribute type="xs:string" name="LastTicketTime"/>
 *   &lt;xs:attribute type="xs:string" name="PrivateFareType"/>
 *   &lt;xs:attribute name="SpanishFamilyDiscountIndicator">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class SpanishFamilyDiscountIndicator -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FlexibleFareID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ShelfId"/>
 *   &lt;xs:attributeGroup ref="ns:AirItineraryPricingInfoExchangeAttributeGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirItineraryPricingInfoType implements Serializable
{
    private Offer offer;
    private ItinTotalFareType itinTotalFare;
    private PTCFareBreakdowns PTCFareBreakdowns1;
    private FareInfos fareInfos;
    private TPAExtensions TPAExtensions1;
    private FareSourceAndTypeAttributes fareSourceAndTypeAttributes;
    private String lastTicketDate;
    private String lastTicketTime;
    private String privateFareType;
    private SpanishFamilyDiscountIndicator spanishFamilyDiscountIndicator;
    private String flexibleFareID;
    private String shelfId;
    private AirItineraryPricingInfoExchangeAttributeGroup airItineraryPricingInfoExchangeAttributeGroup;

    /** 
     * Get the 'Offer' element value.
     * 
     * @return value
     */
    public Offer getOffer() {
        return offer;
    }

    /** 
     * Set the 'Offer' element value.
     * 
     * @param offer
     */
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    /** 
     * Get the 'ItinTotalFare' element value. Total price of the itinerary
     * 
     * @return value
     */
    public ItinTotalFareType getItinTotalFare() {
        return itinTotalFare;
    }

    /** 
     * Set the 'ItinTotalFare' element value. Total price of the itinerary
     * 
     * @param itinTotalFare
     */
    public void setItinTotalFare(ItinTotalFareType itinTotalFare) {
        this.itinTotalFare = itinTotalFare;
    }

    /** 
     * Get the 'PTC_FareBreakdowns' element value.
     * 
     * @return value
     */
    public PTCFareBreakdowns getPTCFareBreakdowns1() {
        return PTCFareBreakdowns1;
    }

    /** 
     * Set the 'PTC_FareBreakdowns' element value.
     * 
     * @param PTCFareBreakdowns1
     */
    public void setPTCFareBreakdowns1(PTCFareBreakdowns PTCFareBreakdowns1) {
        this.PTCFareBreakdowns1 = PTCFareBreakdowns1;
    }

    /** 
     * Get the 'FareInfos' element value.
     * 
     * @return value
     */
    public FareInfos getFareInfos() {
        return fareInfos;
    }

    /** 
     * Set the 'FareInfos' element value.
     * 
     * @param fareInfos
     */
    public void setFareInfos(FareInfos fareInfos) {
        this.fareInfos = fareInfos;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'FareSourceAndTypeAttributes' attributeGroup value.
     * 
     * @return value
     */
    public FareSourceAndTypeAttributes getFareSourceAndTypeAttributes() {
        return fareSourceAndTypeAttributes;
    }

    /** 
     * Set the 'FareSourceAndTypeAttributes' attributeGroup value.
     * 
     * @param fareSourceAndTypeAttributes
     */
    public void setFareSourceAndTypeAttributes(
            FareSourceAndTypeAttributes fareSourceAndTypeAttributes) {
        this.fareSourceAndTypeAttributes = fareSourceAndTypeAttributes;
    }

    /** 
     * Get the 'LastTicketDate' attribute value. Last day to ticket.
     * 
     * @return value
     */
    public String getLastTicketDate() {
        return lastTicketDate;
    }

    /** 
     * Set the 'LastTicketDate' attribute value. Last day to ticket.
     * 
     * @param lastTicketDate
     */
    public void setLastTicketDate(String lastTicketDate) {
        this.lastTicketDate = lastTicketDate;
    }

    /** 
     * Get the 'LastTicketTime' attribute value. Last time to ticket.
     * 
     * @return value
     */
    public String getLastTicketTime() {
        return lastTicketTime;
    }

    /** 
     * Set the 'LastTicketTime' attribute value. Last time to ticket.
     * 
     * @param lastTicketTime
     */
    public void setLastTicketTime(String lastTicketTime) {
        this.lastTicketTime = lastTicketTime;
    }

    /** 
     * Get the 'PrivateFareType' attribute value. Private fare type symbol.
     * 
     * @return value
     */
    public String getPrivateFareType() {
        return privateFareType;
    }

    /** 
     * Set the 'PrivateFareType' attribute value. Private fare type symbol.
     * 
     * @param privateFareType
     */
    public void setPrivateFareType(String privateFareType) {
        this.privateFareType = privateFareType;
    }

    /** 
     * Get the 'SpanishFamilyDiscountIndicator' attribute value. 
            Spanish Discount indicator with values of "A", "B", "C" where
            "A" indicates Spanish Large Family discount only
            "B" indicates Spanish Large Family discount + Spanish Islander discount
            "C" indicates Spanish Islander discount only
          
     * 
     * @return value
     */
    public SpanishFamilyDiscountIndicator getSpanishFamilyDiscountIndicator() {
        return spanishFamilyDiscountIndicator;
    }

    /** 
     * Set the 'SpanishFamilyDiscountIndicator' attribute value. 
            Spanish Discount indicator with values of "A", "B", "C" where
            "A" indicates Spanish Large Family discount only
            "B" indicates Spanish Large Family discount + Spanish Islander discount
            "C" indicates Spanish Islander discount only
          
     * 
     * @param spanishFamilyDiscountIndicator
     */
    public void setSpanishFamilyDiscountIndicator(
            SpanishFamilyDiscountIndicator spanishFamilyDiscountIndicator) {
        this.spanishFamilyDiscountIndicator = spanishFamilyDiscountIndicator;
    }

    /** 
     * Get the 'FlexibleFareID' attribute value. If the fare is an additional flexible fare, this is the fare group ID
     * 
     * @return value
     */
    public String getFlexibleFareID() {
        return flexibleFareID;
    }

    /** 
     * Set the 'FlexibleFareID' attribute value. If the fare is an additional flexible fare, this is the fare group ID
     * 
     * @param flexibleFareID
     */
    public void setFlexibleFareID(String flexibleFareID) {
        this.flexibleFareID = flexibleFareID;
    }

    /** 
     * Get the 'ShelfId' attribute value. Shelf id number
     * 
     * @return value
     */
    public String getShelfId() {
        return shelfId;
    }

    /** 
     * Set the 'ShelfId' attribute value. Shelf id number
     * 
     * @param shelfId
     */
    public void setShelfId(String shelfId) {
        this.shelfId = shelfId;
    }

    /** 
     * Get the 'AirItineraryPricingInfoExchangeAttributeGroup' attributeGroup value.
     * 
     * @return value
     */
    public AirItineraryPricingInfoExchangeAttributeGroup getAirItineraryPricingInfoExchangeAttributeGroup() {
        return airItineraryPricingInfoExchangeAttributeGroup;
    }

    /** 
     * Set the 'AirItineraryPricingInfoExchangeAttributeGroup' attributeGroup value.
     * 
     * @param airItineraryPricingInfoExchangeAttributeGroup
     */
    public void setAirItineraryPricingInfoExchangeAttributeGroup(
            AirItineraryPricingInfoExchangeAttributeGroup airItineraryPricingInfoExchangeAttributeGroup) {
        this.airItineraryPricingInfoExchangeAttributeGroup = airItineraryPricingInfoExchangeAttributeGroup;
    }
    /** 
     * NDC Offer related data
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="OfferId"/>
     *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="TimeToLive"/>
     *     &lt;xs:attribute use="required" name="Source">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Source -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:string" use="optional" name="OfferItemId"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="MandatoryInd"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceId"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Offer implements Serializable
    {
        private String offerId;
        private String timeToLive;
        private Source source;
        private String offerItemId;
        private Boolean mandatoryInd;
        private String serviceId;

        /** 
         * Get the 'OfferId' attribute value. NDC Offer Id
         * 
         * @return value
         */
        public String getOfferId() {
            return offerId;
        }

        /** 
         * Set the 'OfferId' attribute value. NDC Offer Id
         * 
         * @param offerId
         */
        public void setOfferId(String offerId) {
            this.offerId = offerId;
        }

        /** 
         * Get the 'TimeToLive' attribute value. Time to live in seconds
         * 
         * @return value
         */
        public String getTimeToLive() {
            return timeToLive;
        }

        /** 
         * Set the 'TimeToLive' attribute value. Time to live in seconds
         * 
         * @param timeToLive
         */
        public void setTimeToLive(String timeToLive) {
            this.timeToLive = timeToLive;
        }

        /** 
         * Get the 'Source' attribute value. Offer source
         * 
         * @return value
         */
        public Source getSource() {
            return source;
        }

        /** 
         * Set the 'Source' attribute value. Offer source
         * 
         * @param source
         */
        public void setSource(Source source) {
            this.source = source;
        }

        /** 
         * Get the 'OfferItemId' attribute value. NDC OfferItem Id
         * 
         * @return value
         */
        public String getOfferItemId() {
            return offerItemId;
        }

        /** 
         * Set the 'OfferItemId' attribute value. NDC OfferItem Id
         * 
         * @param offerItemId
         */
        public void setOfferItemId(String offerItemId) {
            this.offerItemId = offerItemId;
        }

        /** 
         * Get the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional.
         * 
         * @return value
         */
        public Boolean getMandatoryInd() {
            return mandatoryInd;
        }

        /** 
         * Set the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional.
         * 
         * @param mandatoryInd
         */
        public void setMandatoryInd(Boolean mandatoryInd) {
            this.mandatoryInd = mandatoryInd;
        }

        /** 
         * Get the 'ServiceId' attribute value. NDC Service Id
         * 
         * @return value
         */
        public String getServiceId() {
            return serviceId;
        }

        /** 
         * Set the 'ServiceId' attribute value. NDC Service Id
         * 
         * @param serviceId
         */
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="ATPCO"/>
         *     &lt;xs:enumeration value="LCC"/>
         *     &lt;xs:enumeration value="NDC"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Source implements Serializable {
            ATPCO, LCC, NDC
        }
    }
    /** 
     * This is a collection of PTC Fare Breakdowns
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_FareBreakdowns" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PTCFareBreakdownType" name="PTC_FareBreakdown" maxOccurs="20"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PTCFareBreakdowns implements Serializable
    {
        private List<PTCFareBreakdownType> PTCFareBreakdownList = new ArrayList<PTCFareBreakdownType>();

        /** 
         * Get the list of 'PTC_FareBreakdown' element items.
         * 
         * @return list
         */
        public List<PTCFareBreakdownType> getPTCFareBreakdownList() {
            return PTCFareBreakdownList;
        }

        /** 
         * Set the list of 'PTC_FareBreakdown' element items.
         * 
         * @param list
         */
        public void setPTCFareBreakdownList(List<PTCFareBreakdownType> list) {
            PTCFareBreakdownList = list;
        }
    }
    /** 
     * This is a collection of FareInfo
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareInfo" maxOccurs="10">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareInfos implements Serializable
    {
        private List<FareInfo> fareInfoList = new ArrayList<FareInfo>();

        /** 
         * Get the list of 'FareInfo' element items.
         * 
         * @return list
         */
        public List<FareInfo> getFareInfoList() {
            return fareInfoList;
        }

        /** 
         * Set the list of 'FareInfo' element items.
         * 
         * @param list
         */
        public void setFareInfoList(List<FareInfo> list) {
            fareInfoList = list;
        }
        /** 
         * Detailed information on individual priced fares
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="DepartureDate" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="FareReference"/>
         *       &lt;xs:element type="ns:RuleInfoType" name="RuleInfo" minOccurs="0"/>
         *       &lt;xs:element type="ns:CompanyNameType" name="MarketingAirline" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:ResponseLocationType" name="DepartureAirport" minOccurs="0"/>
         *       &lt;xs:element type="ns:ResponseLocationType" name="ArrivalAirport" minOccurs="0"/>
         *       &lt;xs:element type="ns:FareInfo_TPA_ExtensionsType" name="TPA_Extensions" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:NegotiatedFareAttributes"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private String departureDate;
            private String fareReference;
            private RuleInfoType ruleInfo;
            private List<CompanyNameType> marketingAirlineList = new ArrayList<CompanyNameType>();
            private ResponseLocationType departureAirport;
            private ResponseLocationType arrivalAirport;
            private FareInfoTPAExtensionsType TPAExtensions;
            private NegotiatedFareAttributes negotiatedFareAttributes;

            /** 
             * Get the 'DepartureDate' element value. Departure Date for this priced fare. 
             * 
             * @return value
             */
            public String getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'DepartureDate' element value. Departure Date for this priced fare. 
             * 
             * @param departureDate
             */
            public void setDepartureDate(String departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the 'FareReference' element value. FareReference is the booking code. 
             * 
             * @return value
             */
            public String getFareReference() {
                return fareReference;
            }

            /** 
             * Set the 'FareReference' element value. FareReference is the booking code. 
             * 
             * @param fareReference
             */
            public void setFareReference(String fareReference) {
                this.fareReference = fareReference;
            }

            /** 
             * Get the 'RuleInfo' element value. Information regarding restrictions governing use of the fare.
             * 
             * @return value
             */
            public RuleInfoType getRuleInfo() {
                return ruleInfo;
            }

            /** 
             * Set the 'RuleInfo' element value. Information regarding restrictions governing use of the fare.
             * 
             * @param ruleInfo
             */
            public void setRuleInfo(RuleInfoType ruleInfo) {
                this.ruleInfo = ruleInfo;
            }

            /** 
             * Get the list of 'MarketingAirline' element items. The marketing airline.
             * 
             * @return list
             */
            public List<CompanyNameType> getMarketingAirlineList() {
                return marketingAirlineList;
            }

            /** 
             * Set the list of 'MarketingAirline' element items. The marketing airline.
             * 
             * @param list
             */
            public void setMarketingAirlineList(List<CompanyNameType> list) {
                marketingAirlineList = list;
            }

            /** 
             * Get the 'DepartureAirport' element value. Departure point of flight segment.
             * 
             * @return value
             */
            public ResponseLocationType getDepartureAirport() {
                return departureAirport;
            }

            /** 
             * Set the 'DepartureAirport' element value. Departure point of flight segment.
             * 
             * @param departureAirport
             */
            public void setDepartureAirport(
                    ResponseLocationType departureAirport) {
                this.departureAirport = departureAirport;
            }

            /** 
             * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
             * 
             * @return value
             */
            public ResponseLocationType getArrivalAirport() {
                return arrivalAirport;
            }

            /** 
             * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
             * 
             * @param arrivalAirport
             */
            public void setArrivalAirport(ResponseLocationType arrivalAirport) {
                this.arrivalAirport = arrivalAirport;
            }

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public FareInfoTPAExtensionsType getTPAExtensions() {
                return TPAExtensions;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions
             */
            public void setTPAExtensions(FareInfoTPAExtensionsType TPAExtensions) {
                this.TPAExtensions = TPAExtensions;
            }

            /** 
             * Get the 'NegotiatedFareAttributes' attributeGroup value.
             * 
             * @return value
             */
            public NegotiatedFareAttributes getNegotiatedFareAttributes() {
                return negotiatedFareAttributes;
            }

            /** 
             * Set the 'NegotiatedFareAttributes' attributeGroup value.
             * 
             * @param negotiatedFareAttributes
             */
            public void setNegotiatedFareAttributes(
                    NegotiatedFareAttributes negotiatedFareAttributes) {
                this.negotiatedFareAttributes = negotiatedFareAttributes;
            }
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="DivideInParty" minOccurs="0">
     *         &lt;!-- Reference to inner class DivideInParty -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PromoOffer" minOccurs="0">
     *         &lt;!-- Reference to inner class PromoOffer -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareNote" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FareNote -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PromoRedemption" minOccurs="0">
     *         &lt;!-- Reference to inner class PromoRedemption -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Rule" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Rule -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MultipleTravelerGroups" minOccurs="0">
     *         &lt;!-- Reference to inner class MultipleTravelerGroups -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AncillaryFeeGroups" minOccurs="0">
     *         &lt;!-- Reference to inner class AncillaryFeeGroups -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Legs" minOccurs="0">
     *         &lt;!-- Reference to inner class Legs -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:UnflownPriceType" name="UnflownPrice" minOccurs="0"/>
     *       &lt;xs:element type="ns:ValidatingCarrierInfoType" name="ValidatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private DivideInParty divideInParty;
        private PromoOffer promoOffer;
        private List<FareNote> fareNoteList = new ArrayList<FareNote>();
        private PromoRedemption promoRedemption;
        private List<Rule> ruleList = new ArrayList<Rule>();
        private MultipleTravelerGroups multipleTravelerGroups;
        private AncillaryFeeGroups ancillaryFeeGroups;
        private Legs legs;
        private UnflownPriceType unflownPrice;
        private List<ValidatingCarrierInfoType> validatingCarrierList = new ArrayList<ValidatingCarrierInfoType>();

        /** 
         * Get the 'DivideInParty' element value.
         * 
         * @return value
         */
        public DivideInParty getDivideInParty() {
            return divideInParty;
        }

        /** 
         * Set the 'DivideInParty' element value.
         * 
         * @param divideInParty
         */
        public void setDivideInParty(DivideInParty divideInParty) {
            this.divideInParty = divideInParty;
        }

        /** 
         * Get the 'PromoOffer' element value.
         * 
         * @return value
         */
        public PromoOffer getPromoOffer() {
            return promoOffer;
        }

        /** 
         * Set the 'PromoOffer' element value.
         * 
         * @param promoOffer
         */
        public void setPromoOffer(PromoOffer promoOffer) {
            this.promoOffer = promoOffer;
        }

        /** 
         * Get the list of 'FareNote' element items.
         * 
         * @return list
         */
        public List<FareNote> getFareNoteList() {
            return fareNoteList;
        }

        /** 
         * Set the list of 'FareNote' element items.
         * 
         * @param list
         */
        public void setFareNoteList(List<FareNote> list) {
            fareNoteList = list;
        }

        /** 
         * Get the 'PromoRedemption' element value.
         * 
         * @return value
         */
        public PromoRedemption getPromoRedemption() {
            return promoRedemption;
        }

        /** 
         * Set the 'PromoRedemption' element value.
         * 
         * @param promoRedemption
         */
        public void setPromoRedemption(PromoRedemption promoRedemption) {
            this.promoRedemption = promoRedemption;
        }

        /** 
         * Get the list of 'Rule' element items.
         * 
         * @return list
         */
        public List<Rule> getRuleList() {
            return ruleList;
        }

        /** 
         * Set the list of 'Rule' element items.
         * 
         * @param list
         */
        public void setRuleList(List<Rule> list) {
            ruleList = list;
        }

        /** 
         * Get the 'MultipleTravelerGroups' element value.
         * 
         * @return value
         */
        public MultipleTravelerGroups getMultipleTravelerGroups() {
            return multipleTravelerGroups;
        }

        /** 
         * Set the 'MultipleTravelerGroups' element value.
         * 
         * @param multipleTravelerGroups
         */
        public void setMultipleTravelerGroups(
                MultipleTravelerGroups multipleTravelerGroups) {
            this.multipleTravelerGroups = multipleTravelerGroups;
        }

        /** 
         * Get the 'AncillaryFeeGroups' element value.
         * 
         * @return value
         */
        public AncillaryFeeGroups getAncillaryFeeGroups() {
            return ancillaryFeeGroups;
        }

        /** 
         * Set the 'AncillaryFeeGroups' element value.
         * 
         * @param ancillaryFeeGroups
         */
        public void setAncillaryFeeGroups(AncillaryFeeGroups ancillaryFeeGroups) {
            this.ancillaryFeeGroups = ancillaryFeeGroups;
        }

        /** 
         * Get the 'Legs' element value.
         * 
         * @return value
         */
        public Legs getLegs() {
            return legs;
        }

        /** 
         * Set the 'Legs' element value.
         * 
         * @param legs
         */
        public void setLegs(Legs legs) {
            this.legs = legs;
        }

        /** 
         * Get the 'UnflownPrice' element value.
         * 
         * @return value
         */
        public UnflownPriceType getUnflownPrice() {
            return unflownPrice;
        }

        /** 
         * Set the 'UnflownPrice' element value.
         * 
         * @param unflownPrice
         */
        public void setUnflownPrice(UnflownPriceType unflownPrice) {
            this.unflownPrice = unflownPrice;
        }

        /** 
         * Get the list of 'ValidatingCarrier' element items.
         * 
         * @return list
         */
        public List<ValidatingCarrierInfoType> getValidatingCarrierList() {
            return validatingCarrierList;
        }

        /** 
         * Set the list of 'ValidatingCarrier' element items.
         * 
         * @param list
         */
        public void setValidatingCarrierList(
                List<ValidatingCarrierInfoType> list) {
            validatingCarrierList = list;
        }
        /** 
         * Indicates if different passenger types are booked in different inventories.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DivideInParty" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Indicator"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DivideInParty implements Serializable
        {
            private Boolean indicator;

            /** 
             * Get the 'Indicator' attribute value.
             * 
             * @return value
             */
            public Boolean getIndicator() {
                return indicator;
            }

            /** 
             * Set the 'Indicator' attribute value.
             * 
             * @param indicator
             */
            public void setIndicator(Boolean indicator) {
                this.indicator = indicator;
            }
        }
        /** 
         * Promotional offer
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromoOffer" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="PromoID"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CorpID"/>
         *     &lt;xs:attribute type="xs:string" name="ContentID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PromoOffer implements Serializable
        {
            private String promoID;
            private String corpID;
            private String contentID;

            /** 
             * Get the 'PromoID' attribute value. Promotional offer identifier
             * 
             * @return value
             */
            public String getPromoID() {
                return promoID;
            }

            /** 
             * Set the 'PromoID' attribute value. Promotional offer identifier
             * 
             * @param promoID
             */
            public void setPromoID(String promoID) {
                this.promoID = promoID;
            }

            /** 
             * Get the 'CorpID' attribute value. Airline identifier.
             * 
             * @return value
             */
            public String getCorpID() {
                return corpID;
            }

            /** 
             * Set the 'CorpID' attribute value. Airline identifier.
             * 
             * @param corpID
             */
            public void setCorpID(String corpID) {
                this.corpID = corpID;
            }

            /** 
             * Get the 'ContentID' attribute value. This information comes from Fare Notes Rule fired and is taken by Travelocity to look up detailed data on their database to put on the website.
             * 
             * @return value
             */
            public String getContentID() {
                return contentID;
            }

            /** 
             * Set the 'ContentID' attribute value. This information comes from Fare Notes Rule fired and is taken by Travelocity to look up detailed data on their database to put on the website.
             * 
             * @param contentID
             */
            public void setContentID(String contentID) {
                this.contentID = contentID;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareNote" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="FareTypeName"/>
         *     &lt;xs:attribute type="xs:int" name="PriorityLevel"/>
         *     &lt;xs:attribute type="xs:string" name="ContentID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareNote implements Serializable
        {
            private String fareTypeName;
            private Integer priorityLevel;
            private String contentID;

            /** 
             * Get the 'FareTypeName' attribute value. Corresponds to data in the Fare Note rule (action target: Fare Type). For example: "PROMOTIONAL"
             * 
             * @return value
             */
            public String getFareTypeName() {
                return fareTypeName;
            }

            /** 
             * Set the 'FareTypeName' attribute value. Corresponds to data in the Fare Note rule (action target: Fare Type). For example: "PROMOTIONAL"
             * 
             * @param fareTypeName
             */
            public void setFareTypeName(String fareTypeName) {
                this.fareTypeName = fareTypeName;
            }

            /** 
             * Get the 'PriorityLevel' attribute value. FareNote Itin priority
             * 
             * @return value
             */
            public Integer getPriorityLevel() {
                return priorityLevel;
            }

            /** 
             * Set the 'PriorityLevel' attribute value. FareNote Itin priority
             * 
             * @param priorityLevel
             */
            public void setPriorityLevel(Integer priorityLevel) {
                this.priorityLevel = priorityLevel;
            }

            /** 
             * Get the 'ContentID' attribute value. Corresponds to data in the Fare Note rule (action target: Content ID Action). For example: "112"
             * 
             * @return value
             */
            public String getContentID() {
                return contentID;
            }

            /** 
             * Set the 'ContentID' attribute value. Corresponds to data in the Fare Note rule (action target: Content ID Action). For example: "112"
             * 
             * @param contentID
             */
            public void setContentID(String contentID) {
                this.contentID = contentID;
            }
        }
        /** 
         * Populated if  "Coupon Redemption" rule has been hit. This had been developed for Travelocity but never used.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromoRedemption" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="PromoID"/>
         *     &lt;xs:attribute type="xs:boolean" name="Eligible"/>
         *     &lt;xs:attribute type="xs:string" name="ContentID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PromoRedemption implements Serializable
        {
            private String promoID;
            private Boolean eligible;
            private String contentID;

            /** 
             * Get the 'PromoID' attribute value.
             * 
             * @return value
             */
            public String getPromoID() {
                return promoID;
            }

            /** 
             * Set the 'PromoID' attribute value.
             * 
             * @param promoID
             */
            public void setPromoID(String promoID) {
                this.promoID = promoID;
            }

            /** 
             * Get the 'Eligible' attribute value.
             * 
             * @return value
             */
            public Boolean getEligible() {
                return eligible;
            }

            /** 
             * Set the 'Eligible' attribute value.
             * 
             * @param eligible
             */
            public void setEligible(Boolean eligible) {
                this.eligible = eligible;
            }

            /** 
             * Get the 'ContentID' attribute value.
             * 
             * @return value
             */
            public String getContentID() {
                return contentID;
            }

            /** 
             * Set the 'ContentID' attribute value.
             * 
             * @param contentID
             */
            public void setContentID(String contentID) {
                this.contentID = contentID;
            }
        }
        /** 
         * Describes a rule that was hit.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rule" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="Type"/>
         *     &lt;xs:attribute type="xs:int" name="ID"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rule implements Serializable
        {
            private String type;
            private Integer ID;

            /** 
             * Get the 'Type' attribute value. Rule type. For example: "Fare Note Itin", "DRE"
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. Rule type. For example: "Fare Note Itin", "DRE"
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'ID' attribute value. Rule ID
             * 
             * @return value
             */
            public Integer getID() {
                return ID;
            }

            /** 
             * Set the 'ID' attribute value. Rule ID
             * 
             * @param ID
             */
            public void setID(Integer ID) {
                this.ID = ID;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleTravelerGroups" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="GroupNumber"/>
         *     &lt;xs:attribute type="xs:boolean" name="PrimaryGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MultipleTravelerGroups implements Serializable
        {
            private BigInteger groupNumber;
            private Boolean primaryGroup;

            /** 
             * Get the 'GroupNumber' attribute value.
             * 
             * @return value
             */
            public BigInteger getGroupNumber() {
                return groupNumber;
            }

            /** 
             * Set the 'GroupNumber' attribute value.
             * 
             * @param groupNumber
             */
            public void setGroupNumber(BigInteger groupNumber) {
                this.groupNumber = groupNumber;
            }

            /** 
             * Get the 'PrimaryGroup' attribute value.
             * 
             * @return value
             */
            public Boolean getPrimaryGroup() {
                return primaryGroup;
            }

            /** 
             * Set the 'PrimaryGroup' attribute value.
             * 
             * @param primaryGroup
             */
            public void setPrimaryGroup(Boolean primaryGroup) {
                this.primaryGroup = primaryGroup;
            }
        }
        /** 
         * Ancillary fee groups returned
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFeeGroups" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AncillaryFeeGroup" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class AncillaryFeeGroup -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OrderStandardBag" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class OrderStandardBag -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:anySimpleType" use="optional" name="Message"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AncillaryFeeGroups implements Serializable
        {
            private List<AncillaryFeeGroup> ancillaryFeeGroupList = new ArrayList<AncillaryFeeGroup>();
            private OrderStandardBag orderStandardBag;
            private String message;

            /** 
             * Get the list of 'AncillaryFeeGroup' element items.
             * 
             * @return list
             */
            public List<AncillaryFeeGroup> getAncillaryFeeGroupList() {
                return ancillaryFeeGroupList;
            }

            /** 
             * Set the list of 'AncillaryFeeGroup' element items.
             * 
             * @param list
             */
            public void setAncillaryFeeGroupList(List<AncillaryFeeGroup> list) {
                ancillaryFeeGroupList = list;
            }

            /** 
             * Get the 'OrderStandardBag' element value.
             * 
             * @return value
             */
            public OrderStandardBag getOrderStandardBag() {
                return orderStandardBag;
            }

            /** 
             * Set the 'OrderStandardBag' element value.
             * 
             * @param orderStandardBag
             */
            public void setOrderStandardBag(OrderStandardBag orderStandardBag) {
                this.orderStandardBag = orderStandardBag;
            }

            /** 
             * Get the 'Message' attribute value. Arbitrary message returned from MIP
             * 
             * @return value
             */
            public String getMessage() {
                return message;
            }

            /** 
             * Set the 'Message' attribute value. Arbitrary message returned from MIP
             * 
             * @param message
             */
            public void setMessage(String message) {
                this.message = message;
            }
            /** 
             * Ancillary fee group returned
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFeeGroup" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:OCFeeType" name="AncillaryFeeItem" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Code"/>
             *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Name"/>
             *     &lt;xs:attribute type="xs:anySimpleType" name="Message"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AncillaryFeeGroup implements Serializable
            {
                private List<OCFeeType> ancillaryFeeItemList = new ArrayList<OCFeeType>();
                private String code;
                private String name;
                private String message;

                /** 
                 * Get the list of 'AncillaryFeeItem' element items. OC Fee returned
                 * 
                 * @return list
                 */
                public List<OCFeeType> getAncillaryFeeItemList() {
                    return ancillaryFeeItemList;
                }

                /** 
                 * Set the list of 'AncillaryFeeItem' element items. OC Fee returned
                 * 
                 * @param list
                 */
                public void setAncillaryFeeItemList(List<OCFeeType> list) {
                    ancillaryFeeItemList = list;
                }

                /** 
                 * Get the 'Code' attribute value. Group code
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. Group code
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'Name' attribute value. Group name
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. Group name
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }

                /** 
                 * Get the 'Message' attribute value. Arbitrary message returned from MIP
                 * 
                 * @return value
                 */
                public String getMessage() {
                    return message;
                }

                /** 
                 * Set the 'Message' attribute value. Arbitrary message returned from MIP
                 * 
                 * @param message
                 */
                public void setMessage(String message) {
                    this.message = message;
                }
            }
            /** 
             * Order standard bag for all passenger types
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderStandardBag" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="PassengerBags" minOccurs="1" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class PassengerBags -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OrderStandardBag implements Serializable
            {
                private List<PassengerBags> passengerBagList = new ArrayList<PassengerBags>();

                /** 
                 * Get the list of 'PassengerBags' element items.
                 * 
                 * @return list
                 */
                public List<PassengerBags> getPassengerBagList() {
                    return passengerBagList;
                }

                /** 
                 * Set the list of 'PassengerBags' element items.
                 * 
                 * @param list
                 */
                public void setPassengerBagList(List<PassengerBags> list) {
                    passengerBagList = list;
                }
                /** 
                 * Standards baggage hints for a specific passenger type
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerBags" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="BaggageSequenceOrder" minOccurs="1" maxOccurs="unbounded">
                 *         &lt;!-- Reference to inner class BaggageSequenceOrder -->
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class PassengerBags implements Serializable
                {
                    private List<BaggageSequenceOrder> baggageSequenceOrderList = new ArrayList<BaggageSequenceOrder>();
                    private String code;

                    /** 
                     * Get the list of 'BaggageSequenceOrder' element items.
                     * 
                     * @return list
                     */
                    public List<BaggageSequenceOrder> getBaggageSequenceOrderList() {
                        return baggageSequenceOrderList;
                    }

                    /** 
                     * Set the list of 'BaggageSequenceOrder' element items.
                     * 
                     * @param list
                     */
                    public void setBaggageSequenceOrderList(
                            List<BaggageSequenceOrder> list) {
                        baggageSequenceOrderList = list;
                    }

                    /** 
                     * Get the 'Code' attribute value. Passenger type code
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value. Passenger type code
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                    /** 
                     * Assign Standard baggage hint to Baggage ID
                     * 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageSequenceOrder" minOccurs="1" maxOccurs="unbounded">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:short" use="required" name="BaggageID"/>
                     *     &lt;xs:attribute type="xs:short" use="required" name="StandardBag"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class BaggageSequenceOrder implements
                        Serializable
                    {
                        private Short baggageID;
                        private Short standardBag;

                        /** 
                         * Get the 'BaggageID' attribute value. Baggage ID number referencing AncillaryFeeItem/@BaggageID
                         * 
                         * @return value
                         */
                        public Short getBaggageID() {
                            return baggageID;
                        }

                        /** 
                         * Set the 'BaggageID' attribute value. Baggage ID number referencing AncillaryFeeItem/@BaggageID
                         * 
                         * @param baggageID
                         */
                        public void setBaggageID(Short baggageID) {
                            this.baggageID = baggageID;
                        }

                        /** 
                         * Get the 'StandardBag' attribute value. Standard baggage hint. '1' is first standard baggage, '2' is second standard baggage etc.
                         * 
                         * @return value
                         */
                        public Short getStandardBag() {
                            return standardBag;
                        }

                        /** 
                         * Set the 'StandardBag' attribute value. Standard baggage hint. '1' is first standard baggage, '2' is second standard baggage etc.
                         * 
                         * @param standardBag
                         */
                        public void setStandardBag(Short standardBag) {
                            this.standardBag = standardBag;
                        }
                    }
                }
            }
        }
        /** 
         * This is a collection of Leg Information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Legs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Leg" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Leg -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Legs implements Serializable
        {
            private List<Leg> legList = new ArrayList<Leg>();

            /** 
             * Get the list of 'Leg' element items.
             * 
             * @return list
             */
            public List<Leg> getLegList() {
                return legList;
            }

            /** 
             * Set the list of 'Leg' element items.
             * 
             * @param list
             */
            public void setLegList(List<Leg> list) {
                legList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Leg" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:anySimpleType" name="Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="BrandID"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="BrandDescription"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramName"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramID"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramSystemCode"/>
             *     &lt;xs:attribute type="xs:string" name="FareStatus"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Leg implements Serializable
            {
                private List<Segment> segmentList = new ArrayList<Segment>();
                private String number;
                private String brandID;
                private String brandDescription;
                private String programName;
                private String programID;
                private String programCode;
                private String programSystemCode;
                private String fareStatus;

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public String getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(String number) {
                    this.number = number;
                }

                /** 
                 * Get the 'BrandID' attribute value.
                 * 
                 * @return value
                 */
                public String getBrandID() {
                    return brandID;
                }

                /** 
                 * Set the 'BrandID' attribute value.
                 * 
                 * @param brandID
                 */
                public void setBrandID(String brandID) {
                    this.brandID = brandID;
                }

                /** 
                 * Get the 'BrandDescription' attribute value.
                 * 
                 * @return value
                 */
                public String getBrandDescription() {
                    return brandDescription;
                }

                /** 
                 * Set the 'BrandDescription' attribute value.
                 * 
                 * @param brandDescription
                 */
                public void setBrandDescription(String brandDescription) {
                    this.brandDescription = brandDescription;
                }

                /** 
                 * Get the 'ProgramName' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramName() {
                    return programName;
                }

                /** 
                 * Set the 'ProgramName' attribute value.
                 * 
                 * @param programName
                 */
                public void setProgramName(String programName) {
                    this.programName = programName;
                }

                /** 
                 * Get the 'ProgramID' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramID() {
                    return programID;
                }

                /** 
                 * Set the 'ProgramID' attribute value.
                 * 
                 * @param programID
                 */
                public void setProgramID(String programID) {
                    this.programID = programID;
                }

                /** 
                 * Get the 'ProgramCode' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramCode() {
                    return programCode;
                }

                /** 
                 * Set the 'ProgramCode' attribute value.
                 * 
                 * @param programCode
                 */
                public void setProgramCode(String programCode) {
                    this.programCode = programCode;
                }

                /** 
                 * Get the 'ProgramSystemCode' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramSystemCode() {
                    return programSystemCode;
                }

                /** 
                 * Set the 'ProgramSystemCode' attribute value.
                 * 
                 * @param programSystemCode
                 */
                public void setProgramSystemCode(String programSystemCode) {
                    this.programSystemCode = programSystemCode;
                }

                /** 
                 * Get the 'FareStatus' attribute value. Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status, "P" - "Original/Main brand is replaced due to lack of brand parity condition on this leg (Branded Fares Diversity)".
                 * 
                 * @return value
                 */
                public String getFareStatus() {
                    return fareStatus;
                }

                /** 
                 * Set the 'FareStatus' attribute value. Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status, "P" - "Original/Main brand is replaced due to lack of brand parity condition on this leg (Branded Fares Diversity)".
                 * 
                 * @param fareStatus
                 */
                public void setFareStatus(String fareStatus) {
                    this.fareStatus = fareStatus;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:int" use="optional" name="Number"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramDescription"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramSystemCode"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="BrandID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="BrandName"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private Integer number;
                    private String programID;
                    private String programCode;
                    private String programDescription;
                    private String programSystemCode;
                    private String brandID;
                    private String brandName;

                    /** 
                     * Get the 'Number' attribute value. Reference to the flight segment
                     * 
                     * @return value
                     */
                    public Integer getNumber() {
                        return number;
                    }

                    /** 
                     * Set the 'Number' attribute value. Reference to the flight segment
                     * 
                     * @param number
                     */
                    public void setNumber(Integer number) {
                        this.number = number;
                    }

                    /** 
                     * Get the 'ProgramID' attribute value.
                     * 
                     * @return value
                     */
                    public String getProgramID() {
                        return programID;
                    }

                    /** 
                     * Set the 'ProgramID' attribute value.
                     * 
                     * @param programID
                     */
                    public void setProgramID(String programID) {
                        this.programID = programID;
                    }

                    /** 
                     * Get the 'ProgramCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getProgramCode() {
                        return programCode;
                    }

                    /** 
                     * Set the 'ProgramCode' attribute value.
                     * 
                     * @param programCode
                     */
                    public void setProgramCode(String programCode) {
                        this.programCode = programCode;
                    }

                    /** 
                     * Get the 'ProgramDescription' attribute value.
                     * 
                     * @return value
                     */
                    public String getProgramDescription() {
                        return programDescription;
                    }

                    /** 
                     * Set the 'ProgramDescription' attribute value.
                     * 
                     * @param programDescription
                     */
                    public void setProgramDescription(String programDescription) {
                        this.programDescription = programDescription;
                    }

                    /** 
                     * Get the 'ProgramSystemCode' attribute value.
                     * 
                     * @return value
                     */
                    public String getProgramSystemCode() {
                        return programSystemCode;
                    }

                    /** 
                     * Set the 'ProgramSystemCode' attribute value.
                     * 
                     * @param programSystemCode
                     */
                    public void setProgramSystemCode(String programSystemCode) {
                        this.programSystemCode = programSystemCode;
                    }

                    /** 
                     * Get the 'BrandID' attribute value.
                     * 
                     * @return value
                     */
                    public String getBrandID() {
                        return brandID;
                    }

                    /** 
                     * Set the 'BrandID' attribute value.
                     * 
                     * @param brandID
                     */
                    public void setBrandID(String brandID) {
                        this.brandID = brandID;
                    }

                    /** 
                     * Get the 'BrandName' attribute value. Used to indicate brand name
                     * 
                     * @return value
                     */
                    public String getBrandName() {
                        return brandName;
                    }

                    /** 
                     * Set the 'BrandName' attribute value. Used to indicate brand name
                     * 
                     * @param brandName
                     */
                    public void setBrandName(String brandName) {
                        this.brandName = brandName;
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="A"/>
     *     &lt;xs:enumeration value="B"/>
     *     &lt;xs:enumeration value="C"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum SpanishFamilyDiscountIndicator implements Serializable {
        A, B, C
    }
}
