
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Specifies the origin and destination of the traveler.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirItineraryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OriginDestinationOptions" minOccurs="0">
 *       &lt;!-- Reference to inner class OriginDestinationOptions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:AirTripType" use="optional" name="DirectionInd"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="DepartureDate"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirItineraryType implements Serializable
{
    private OriginDestinationOptions originDestinationOptions;
    private AirTripType directionInd;
    private Date departureDate;

    /** 
     * Get the 'OriginDestinationOptions' element value.
     * 
     * @return value
     */
    public OriginDestinationOptions getOriginDestinationOptions() {
        return originDestinationOptions;
    }

    /** 
     * Set the 'OriginDestinationOptions' element value.
     * 
     * @param originDestinationOptions
     */
    public void setOriginDestinationOptions(
            OriginDestinationOptions originDestinationOptions) {
        this.originDestinationOptions = originDestinationOptions;
    }

    /** 
     * Get the 'DirectionInd' attribute value. A directional indicator that identifies a type of air booking (e.g. one-way, round-trip, open-jaw).
     * 
     * @return value
     */
    public AirTripType getDirectionInd() {
        return directionInd;
    }

    /** 
     * Set the 'DirectionInd' attribute value. A directional indicator that identifies a type of air booking (e.g. one-way, round-trip, open-jaw).
     * 
     * @param directionInd
     */
    public void setDirectionInd(AirTripType directionInd) {
        this.directionInd = directionInd;
    }

    /** 
     * Get the 'DepartureDate' attribute value. Itinerary departure date
     * 
     * @return value
     */
    public Date getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' attribute value. Itinerary departure date
     * 
     * @param departureDate
     */
    public void setDepartureDate(Date departureDate) {
        this.departureDate = departureDate;
    }
    /** 
     * A collection of  OriginDestinationOption
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationOptions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OriginDestinationOptionType" name="OriginDestinationOption" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginDestinationOptions implements Serializable
    {
        private List<OriginDestinationOptionType> originDestinationOptionList = new ArrayList<OriginDestinationOptionType>();

        /** 
         * Get the list of 'OriginDestinationOption' element items. A container for flight segments.
         * 
         * @return list
         */
        public List<OriginDestinationOptionType> getOriginDestinationOptionList() {
            return originDestinationOptionList;
        }

        /** 
         * Set the list of 'OriginDestinationOption' element items. A container for flight segments.
         * 
         * @param list
         */
        public void setOriginDestinationOptionList(
                List<OriginDestinationOptionType> list) {
            originDestinationOptionList = list;
        }
    }
}
