
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTaxReissueAttributeGroup">
 *   &lt;xs:attribute type="xs:string" name="ReissueTaxType"/>
 *   &lt;xs:attribute type="xs:boolean" default="false" name="ReissueRestrictionApplies"/>
 *   &lt;xs:attribute type="xs:boolean" default="true" name="ReissueTaxRefundable"/>
 *   &lt;xs:attribute type="xs:boolean" default="false" name="ApplyToReissue"/>
 *   &lt;xs:attribute type="xs:double" name="ReissueMaxAmount"/>
 *   &lt;xs:attribute type="xs:string" name="ReissueCurrency"/>
 *   &lt;xs:attribute type="xs:double" name="PublishedAmount"/>
 *   &lt;xs:attribute type="xs:string" name="PublishedCurrency"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AirTaxReissueAttributeGroup implements Serializable
{
    private String reissueTaxType;
    private Boolean reissueRestrictionApplies;
    private Boolean reissueTaxRefundable;
    private Boolean applyToReissue;
    private Double reissueMaxAmount;
    private String reissueCurrency;
    private Double publishedAmount;
    private String publishedCurrency;

    /** 
     * Get the 'ReissueTaxType' attribute value. Reissue tax type
     * 
     * @return value
     */
    public String getReissueTaxType() {
        return reissueTaxType;
    }

    /** 
     * Set the 'ReissueTaxType' attribute value. Reissue tax type
     * 
     * @param reissueTaxType
     */
    public void setReissueTaxType(String reissueTaxType) {
        this.reissueTaxType = reissueTaxType;
    }

    /** 
     * Get the 'ReissueRestrictionApplies' attribute value.
     * 
     * @return value
     */
    public Boolean getReissueRestrictionApplies() {
        return reissueRestrictionApplies;
    }

    /** 
     * Set the 'ReissueRestrictionApplies' attribute value.
     * 
     * @param reissueRestrictionApplies
     */
    public void setReissueRestrictionApplies(Boolean reissueRestrictionApplies) {
        this.reissueRestrictionApplies = reissueRestrictionApplies;
    }

    /** 
     * Get the 'ReissueTaxRefundable' attribute value.
     * 
     * @return value
     */
    public Boolean getReissueTaxRefundable() {
        return reissueTaxRefundable;
    }

    /** 
     * Set the 'ReissueTaxRefundable' attribute value.
     * 
     * @param reissueTaxRefundable
     */
    public void setReissueTaxRefundable(Boolean reissueTaxRefundable) {
        this.reissueTaxRefundable = reissueTaxRefundable;
    }

    /** 
     * Get the 'ApplyToReissue' attribute value.
     * 
     * @return value
     */
    public Boolean getApplyToReissue() {
        return applyToReissue;
    }

    /** 
     * Set the 'ApplyToReissue' attribute value.
     * 
     * @param applyToReissue
     */
    public void setApplyToReissue(Boolean applyToReissue) {
        this.applyToReissue = applyToReissue;
    }

    /** 
     * Get the 'ReissueMaxAmount' attribute value.
     * 
     * @return value
     */
    public Double getReissueMaxAmount() {
        return reissueMaxAmount;
    }

    /** 
     * Set the 'ReissueMaxAmount' attribute value.
     * 
     * @param reissueMaxAmount
     */
    public void setReissueMaxAmount(Double reissueMaxAmount) {
        this.reissueMaxAmount = reissueMaxAmount;
    }

    /** 
     * Get the 'ReissueCurrency' attribute value. Reissue tax max amount currency
     * 
     * @return value
     */
    public String getReissueCurrency() {
        return reissueCurrency;
    }

    /** 
     * Set the 'ReissueCurrency' attribute value. Reissue tax max amount currency
     * 
     * @param reissueCurrency
     */
    public void setReissueCurrency(String reissueCurrency) {
        this.reissueCurrency = reissueCurrency;
    }

    /** 
     * Get the 'PublishedAmount' attribute value.
     * 
     * @return value
     */
    public Double getPublishedAmount() {
        return publishedAmount;
    }

    /** 
     * Set the 'PublishedAmount' attribute value.
     * 
     * @param publishedAmount
     */
    public void setPublishedAmount(Double publishedAmount) {
        this.publishedAmount = publishedAmount;
    }

    /** 
     * Get the 'PublishedCurrency' attribute value.
     * 
     * @return value
     */
    public String getPublishedCurrency() {
        return publishedCurrency;
    }

    /** 
     * Set the 'PublishedCurrency' attribute value.
     * 
     * @param publishedCurrency
     */
    public void setPublishedCurrency(String publishedCurrency) {
        this.publishedCurrency = publishedCurrency;
    }
}
