
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 Defines the data fields available for air tax summary.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTaxSummaryType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
 *       &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
 *       &lt;xs:attribute type="xs:integer" use="optional" name="PointsAmount"/>
 *       &lt;xs:attribute type="xs:string" name="StationCode"/>
 *       &lt;xs:attribute type="xs:string" name="CountryCode"/>
 *       &lt;xs:attribute type="xs:double" name="PublishedAmount"/>
 *       &lt;xs:attribute type="xs:string" name="PublishedCurrency"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirTaxSummaryType implements Serializable
{
    private String string;
    private String taxCode;
    private CurrencyAmountGroup currencyAmountGroup;
    private BigInteger pointsAmount;
    private String stationCode;
    private String countryCode;
    private Double publishedAmount;
    private String publishedCurrency;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'TaxCode' attribute value. 
                Identifies the code for the tax.
              
     * 
     * @return value
     */
    public String getTaxCode() {
        return taxCode;
    }

    /** 
     * Set the 'TaxCode' attribute value. 
                Identifies the code for the tax.
              
     * 
     * @param taxCode
     */
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    /** 
     * Get the 'CurrencyAmountGroup' attributeGroup value.
     * 
     * @return value
     */
    public CurrencyAmountGroup getCurrencyAmountGroup() {
        return currencyAmountGroup;
    }

    /** 
     * Set the 'CurrencyAmountGroup' attributeGroup value.
     * 
     * @param currencyAmountGroup
     */
    public void setCurrencyAmountGroup(CurrencyAmountGroup currencyAmountGroup) {
        this.currencyAmountGroup = currencyAmountGroup;
    }

    /** 
     * Get the 'PointsAmount' attribute value. Tax amount in points
     * 
     * @return value
     */
    public BigInteger getPointsAmount() {
        return pointsAmount;
    }

    /** 
     * Set the 'PointsAmount' attribute value. Tax amount in points
     * 
     * @param pointsAmount
     */
    public void setPointsAmount(BigInteger pointsAmount) {
        this.pointsAmount = pointsAmount;
    }

    /** 
     * Get the 'StationCode' attribute value. Airport code at which the tax or surcharge is being applied
     * 
     * @return value
     */
    public String getStationCode() {
        return stationCode;
    }

    /** 
     * Set the 'StationCode' attribute value. Airport code at which the tax or surcharge is being applied
     * 
     * @param stationCode
     */
    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    /** 
     * Get the 'CountryCode' attribute value. Tax Country Code
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' attribute value. Tax Country Code
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'PublishedAmount' attribute value.
     * 
     * @return value
     */
    public Double getPublishedAmount() {
        return publishedAmount;
    }

    /** 
     * Set the 'PublishedAmount' attribute value.
     * 
     * @param publishedAmount
     */
    public void setPublishedAmount(Double publishedAmount) {
        this.publishedAmount = publishedAmount;
    }

    /** 
     * Get the 'PublishedCurrency' attribute value.
     * 
     * @return value
     */
    public String getPublishedCurrency() {
        return publishedCurrency;
    }

    /** 
     * Set the 'PublishedCurrency' attribute value.
     * 
     * @param publishedCurrency
     */
    public void setPublishedCurrency(String publishedCurrency) {
        this.publishedCurrency = publishedCurrency;
    }
}
