
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 Defines the data fields available for air tax.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTaxType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="required" name="TaxCode"/>
 *       &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
 *       &lt;xs:attribute type="xs:integer" use="optional" name="PointsAmount"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="CarrierCode"/>
 *       &lt;xs:attributeGroup ref="ns:MinMaxTaxAttributeGroup"/>
 *       &lt;xs:attribute type="xs:double" name="RateUsed"/>
 *       &lt;xs:attribute type="xs:string" name="StationCode"/>
 *       &lt;xs:attribute type="xs:string" name="CountryCode"/>
 *       &lt;xs:attributeGroup ref="ns:AirTaxReissueAttributeGroup"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="TaxOnChangeFee"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="Refundable"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirTaxType implements Serializable
{
    private String string;
    private String taxCode;
    private CurrencyAmountGroup currencyAmountGroup;
    private BigInteger pointsAmount;
    private String carrierCode;
    private MinMaxTaxAttributeGroup minMaxTaxAttributeGroup;
    private Double rateUsed;
    private String stationCode;
    private String countryCode;
    private AirTaxReissueAttributeGroup airTaxReissueAttributeGroup;
    private Boolean taxOnChangeFee;
    private Boolean refundable;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'TaxCode' attribute value. 
                Identifies the code for the tax.
              
     * 
     * @return value
     */
    public String getTaxCode() {
        return taxCode;
    }

    /** 
     * Set the 'TaxCode' attribute value. 
                Identifies the code for the tax.
              
     * 
     * @param taxCode
     */
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    /** 
     * Get the 'CurrencyAmountGroup' attributeGroup value.
     * 
     * @return value
     */
    public CurrencyAmountGroup getCurrencyAmountGroup() {
        return currencyAmountGroup;
    }

    /** 
     * Set the 'CurrencyAmountGroup' attributeGroup value.
     * 
     * @param currencyAmountGroup
     */
    public void setCurrencyAmountGroup(CurrencyAmountGroup currencyAmountGroup) {
        this.currencyAmountGroup = currencyAmountGroup;
    }

    /** 
     * Get the 'PointsAmount' attribute value. Tax amount in points
     * 
     * @return value
     */
    public BigInteger getPointsAmount() {
        return pointsAmount;
    }

    /** 
     * Set the 'PointsAmount' attribute value. Tax amount in points
     * 
     * @param pointsAmount
     */
    public void setPointsAmount(BigInteger pointsAmount) {
        this.pointsAmount = pointsAmount;
    }

    /** 
     * Get the 'CarrierCode' attribute value. carrier used for this tax
     * 
     * @return value
     */
    public String getCarrierCode() {
        return carrierCode;
    }

    /** 
     * Set the 'CarrierCode' attribute value. carrier used for this tax
     * 
     * @param carrierCode
     */
    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    /** 
     * Get the 'MinMaxTaxAttributeGroup' attributeGroup value.
     * 
     * @return value
     */
    public MinMaxTaxAttributeGroup getMinMaxTaxAttributeGroup() {
        return minMaxTaxAttributeGroup;
    }

    /** 
     * Set the 'MinMaxTaxAttributeGroup' attributeGroup value.
     * 
     * @param minMaxTaxAttributeGroup
     */
    public void setMinMaxTaxAttributeGroup(
            MinMaxTaxAttributeGroup minMaxTaxAttributeGroup) {
        this.minMaxTaxAttributeGroup = minMaxTaxAttributeGroup;
    }

    /** 
     * Get the 'RateUsed' attribute value. Tax rate used
     * 
     * @return value
     */
    public Double getRateUsed() {
        return rateUsed;
    }

    /** 
     * Set the 'RateUsed' attribute value. Tax rate used
     * 
     * @param rateUsed
     */
    public void setRateUsed(Double rateUsed) {
        this.rateUsed = rateUsed;
    }

    /** 
     * Get the 'StationCode' attribute value. Airport code at which the tax or surcharge is being applied
     * 
     * @return value
     */
    public String getStationCode() {
        return stationCode;
    }

    /** 
     * Set the 'StationCode' attribute value. Airport code at which the tax or surcharge is being applied
     * 
     * @param stationCode
     */
    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    /** 
     * Get the 'CountryCode' attribute value. Tax Country Code
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' attribute value. Tax Country Code
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'AirTaxReissueAttributeGroup' attributeGroup value.
     * 
     * @return value
     */
    public AirTaxReissueAttributeGroup getAirTaxReissueAttributeGroup() {
        return airTaxReissueAttributeGroup;
    }

    /** 
     * Set the 'AirTaxReissueAttributeGroup' attributeGroup value.
     * 
     * @param airTaxReissueAttributeGroup
     */
    public void setAirTaxReissueAttributeGroup(
            AirTaxReissueAttributeGroup airTaxReissueAttributeGroup) {
        this.airTaxReissueAttributeGroup = airTaxReissueAttributeGroup;
    }

    /** 
     * Get the 'TaxOnChangeFee' attribute value.
     * 
     * @return value
     */
    public Boolean getTaxOnChangeFee() {
        return taxOnChangeFee;
    }

    /** 
     * Set the 'TaxOnChangeFee' attribute value.
     * 
     * @param taxOnChangeFee
     */
    public void setTaxOnChangeFee(Boolean taxOnChangeFee) {
        this.taxOnChangeFee = taxOnChangeFee;
    }

    /** 
     * Get the 'Refundable' attribute value. Is tax amount refundable during exchange
     * 
     * @return value
     */
    public Boolean getRefundable() {
        return refundable;
    }

    /** 
     * Set the 'Refundable' attribute value. Is tax amount refundable during exchange
     * 
     * @param refundable
     */
    public void setRefundable(Boolean refundable) {
        this.refundable = refundable;
    }
}
