
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information about the person traveling. Gender - the gender of the customer, if needed. BirthDate - Date of Birth. Currency - the preferred currency in which monetary amounts should be returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirTravelerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ProfileRef" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:UniqueID_Type" name="UniqueID"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PersonNameType" name="PersonName"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:CustLoyaltyType" name="CustLoyalty" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:DocumentType" name="Document" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:PassengerTypeQuantityType" name="PassengerTypeQuantity" minOccurs="0"/>
 *     &lt;xs:element type="ns:TravelerRefNumberType" name="TravelerRefNumber"/>
 *     &lt;xs:element name="FlightSegmentRPHs" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightSegmentRPHs -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:GenderGroup"/>
 *   &lt;xs:attributeGroup ref="ns:PrivacyGroup"/>
 *   &lt;xs:attribute type="xs:date" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" name="CurrencyCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PassengerTypeCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AccompaniedByInfant"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirTravelerType implements Serializable
{
    private UniqueIDType profileRef;
    private PersonNameType personName;
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<CustLoyaltyType> custLoyaltyList = new ArrayList<CustLoyaltyType>();
    private List<DocumentType> documentList = new ArrayList<DocumentType>();
    private PassengerTypeQuantityType passengerTypeQuantity;
    private TravelerRefNumberType travelerRefNumber;
    private FlightSegmentRPHs flightSegmentRPHs;
    private GenderGroup genderGroup;
    private PrivacyGroup privacyGroup;
    private Date birthDate;
    private String currencyCode;
    private String passengerTypeCode;
    private Boolean accompaniedByInfant;

    /** 
     * Get the 'UniqueID' element value. Stored information about a customer. May contain readily available information relevant to the booking.
     * 
     * @return value
     */
    public UniqueIDType getProfileRef() {
        return profileRef;
    }

    /** 
     * Set the 'UniqueID' element value. Stored information about a customer. May contain readily available information relevant to the booking.
     * 
     * @param profileRef
     */
    public void setProfileRef(UniqueIDType profileRef) {
        this.profileRef = profileRef;
    }

    /** 
     * Get the 'PersonName' element value.
     * 
     * @return value
     */
    public PersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value.
     * 
     * @param personName
     */
    public void setPersonName(PersonNameType personName) {
        this.personName = personName;
    }

    /** 
     * Get the list of 'Telephone' element items.
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items.
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items.
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items.
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items.
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items.
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'CustLoyalty' element items. Specify a customer loyalty program.
     * 
     * @return list
     */
    public List<CustLoyaltyType> getCustLoyaltyList() {
        return custLoyaltyList;
    }

    /** 
     * Set the list of 'CustLoyalty' element items. Specify a customer loyalty program.
     * 
     * @param list
     */
    public void setCustLoyaltyList(List<CustLoyaltyType> list) {
        custLoyaltyList = list;
    }

    /** 
     * Get the list of 'Document' element items.
     * 
     * @return list
     */
    public List<DocumentType> getDocumentList() {
        return documentList;
    }

    /** 
     * Set the list of 'Document' element items.
     * 
     * @param list
     */
    public void setDocumentList(List<DocumentType> list) {
        documentList = list;
    }

    /** 
     * Get the 'PassengerTypeQuantity' element value. Define information on the number of passengers of a specific type.
     * 
     * @return value
     */
    public PassengerTypeQuantityType getPassengerTypeQuantity() {
        return passengerTypeQuantity;
    }

    /** 
     * Set the 'PassengerTypeQuantity' element value. Define information on the number of passengers of a specific type.
     * 
     * @param passengerTypeQuantity
     */
    public void setPassengerTypeQuantity(
            PassengerTypeQuantityType passengerTypeQuantity) {
        this.passengerTypeQuantity = passengerTypeQuantity;
    }

    /** 
     * Get the 'TravelerRefNumber' element value. Direct reference of traveler assigned by requesting system. Used as a cross reference between data segments.
     * 
     * @return value
     */
    public TravelerRefNumberType getTravelerRefNumber() {
        return travelerRefNumber;
    }

    /** 
     * Set the 'TravelerRefNumber' element value. Direct reference of traveler assigned by requesting system. Used as a cross reference between data segments.
     * 
     * @param travelerRefNumber
     */
    public void setTravelerRefNumber(TravelerRefNumberType travelerRefNumber) {
        this.travelerRefNumber = travelerRefNumber;
    }

    /** 
     * Get the 'FlightSegmentRPHs' element value.
     * 
     * @return value
     */
    public FlightSegmentRPHs getFlightSegmentRPHs() {
        return flightSegmentRPHs;
    }

    /** 
     * Set the 'FlightSegmentRPHs' element value.
     * 
     * @param flightSegmentRPHs
     */
    public void setFlightSegmentRPHs(FlightSegmentRPHs flightSegmentRPHs) {
        this.flightSegmentRPHs = flightSegmentRPHs;
    }

    /** 
     * Get the 'GenderGroup' attributeGroup value.
     * 
     * @return value
     */
    public GenderGroup getGenderGroup() {
        return genderGroup;
    }

    /** 
     * Set the 'GenderGroup' attributeGroup value.
     * 
     * @param genderGroup
     */
    public void setGenderGroup(GenderGroup genderGroup) {
        this.genderGroup = genderGroup;
    }

    /** 
     * Get the 'PrivacyGroup' attributeGroup value.
     * 
     * @return value
     */
    public PrivacyGroup getPrivacyGroup() {
        return privacyGroup;
    }

    /** 
     * Set the 'PrivacyGroup' attributeGroup value.
     * 
     * @param privacyGroup
     */
    public void setPrivacyGroup(PrivacyGroup privacyGroup) {
        this.privacyGroup = privacyGroup;
    }

    /** 
     * Get the 'BirthDate' attribute value. Date of Birth.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. Date of Birth.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'CurrencyCode' attribute value. The preferred currency in which monetary amounts should be returned.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value. The preferred currency in which monetary amounts should be returned.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'PassengerTypeCode' attribute value. A three-letter code representing passenger type (e.g. .ADT. for adult, .CNN. for child)
     * 
     * @return value
     */
    public String getPassengerTypeCode() {
        return passengerTypeCode;
    }

    /** 
     * Set the 'PassengerTypeCode' attribute value. A three-letter code representing passenger type (e.g. .ADT. for adult, .CNN. for child)
     * 
     * @param passengerTypeCode
     */
    public void setPassengerTypeCode(String passengerTypeCode) {
        this.passengerTypeCode = passengerTypeCode;
    }

    /** 
     * Get the 'AccompaniedByInfant' attribute value. Indicates if an infant accompanying a traveler is with or without a seat.
     * 
     * @return value
     */
    public Boolean getAccompaniedByInfant() {
        return accompaniedByInfant;
    }

    /** 
     * Set the 'AccompaniedByInfant' attribute value. Indicates if an infant accompanying a traveler is with or without a seat.
     * 
     * @param accompaniedByInfant
     */
    public void setAccompaniedByInfant(Boolean accompaniedByInfant) {
        this.accompaniedByInfant = accompaniedByInfant;
    }
    /** 
     * Reference pointers to flight segments
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightSegmentRPHs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="FlightSegmentRPH" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightSegmentRPHs implements Serializable
    {
        private List<String> flightSegmentRPHList = new ArrayList<String>();

        /** 
         * Get the list of 'FlightSegmentRPH' element items. Reference to the flight segments for this traveler
         * 
         * @return list
         */
        public List<String> getFlightSegmentRPHList() {
            return flightSegmentRPHList;
        }

        /** 
         * Set the list of 'FlightSegmentRPH' element items. Reference to the flight segments for this traveler
         * 
         * @param list
         */
        public void setFlightSegmentRPHList(List<String> list) {
            flightSegmentRPHList = list;
        }
    }
}
