
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Which (if any) alt cities locations should be handled in a special way (i.e. Validate instead of precomputed path).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AltCitiesCombinationsType">
 *   &lt;xs:attribute type="ns:AltCitiesCombinationsLocationsType" use="optional" default="Main" name="Origins"/>
 *   &lt;xs:attribute type="ns:AltCitiesCombinationsLocationsType" use="optional" default="Main" name="Destinations"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AltCitiesCombinationsType implements Serializable
{
    private AltCitiesCombinationsLocationsType origins;
    private AltCitiesCombinationsLocationsType destinations;

    /** 
     * Get the 'Origins' attribute value. Which origins to process in live path (All or Main only)
     * 
     * @return value
     */
    public AltCitiesCombinationsLocationsType getOrigins() {
        return origins;
    }

    /** 
     * Set the 'Origins' attribute value. Which origins to process in live path (All or Main only)
     * 
     * @param origins
     */
    public void setOrigins(AltCitiesCombinationsLocationsType origins) {
        this.origins = origins;
    }

    /** 
     * Get the 'Destinations' attribute value. Which destinations to process in live path (All or Main only)
     * 
     * @return value
     */
    public AltCitiesCombinationsLocationsType getDestinations() {
        return destinations;
    }

    /** 
     * Set the 'Destinations' attribute value. Which destinations to process in live path (All or Main only)
     * 
     * @param destinations
     */
    public void setDestinations(AltCitiesCombinationsLocationsType destinations) {
        this.destinations = destinations;
    }
}
