
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternatePCCType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="TravelPreferences" minOccurs="0">
 *       &lt;!-- Reference to inner class TravelPreferences -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="PseudoCityCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AlternatePCCType implements Serializable
{
    private TravelPreferences travelPreferences;
    private String pseudoCityCode;

    /** 
     * Get the 'TravelPreferences' element value.
     * 
     * @return value
     */
    public TravelPreferences getTravelPreferences() {
        return travelPreferences;
    }

    /** 
     * Set the 'TravelPreferences' element value.
     * 
     * @param travelPreferences
     */
    public void setTravelPreferences(TravelPreferences travelPreferences) {
        this.travelPreferences = travelPreferences;
    }

    /** 
     * Get the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPreferences" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="VendorPref" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class VendorPref -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TPA_Extensions" minOccurs="0">
     *         &lt;!-- Reference to inner class TPAExtensions -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelPreferences implements Serializable
    {
        private List<VendorPref> vendorPrefList = new ArrayList<VendorPref>();
        private TPAExtensions TPAExtensions1;

        /** 
         * Get the list of 'VendorPref' element items.
         * 
         * @return list
         */
        public List<VendorPref> getVendorPrefList() {
            return vendorPrefList;
        }

        /** 
         * Set the list of 'VendorPref' element items.
         * 
         * @param list
         */
        public void setVendorPrefList(List<VendorPref> list) {
            vendorPrefList = list;
        }

        /** 
         * Get the 'TPA_Extensions' element value.
         * 
         * @return value
         */
        public TPAExtensions getTPAExtensions1() {
            return TPAExtensions1;
        }

        /** 
         * Set the 'TPA_Extensions' element value.
         * 
         * @param TPAExtensions1
         */
        public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
            this.TPAExtensions1 = TPAExtensions1;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPref" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *     &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="PreferLevel"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VendorPref implements Serializable
        {
            private String code;
            private PreferLevelType preferLevel;

            /** 
             * Get the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'PreferLevel' attribute value.
             * 
             * @return value
             */
            public PreferLevelType getPreferLevel() {
                return preferLevel;
            }

            /** 
             * Set the 'PreferLevel' attribute value.
             * 
             * @param preferLevel
             */
            public void setPreferLevel(PreferLevelType preferLevel) {
                this.preferLevel = preferLevel;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:AllianceType" name="IncludeAlliancePref" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:AllianceType" name="ExcludeAlliancePref" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TPAExtensions implements Serializable
        {
            private List<AllianceType> includeAlliancePrefList = new ArrayList<AllianceType>();
            private List<AllianceType> excludeAlliancePrefList = new ArrayList<AllianceType>();

            /** 
             * Get the list of 'IncludeAlliancePref' element items. Consider only these alliances.
             * 
             * @return list
             */
            public List<AllianceType> getIncludeAlliancePrefList() {
                return includeAlliancePrefList;
            }

            /** 
             * Set the list of 'IncludeAlliancePref' element items. Consider only these alliances.
             * 
             * @param list
             */
            public void setIncludeAlliancePrefList(List<AllianceType> list) {
                includeAlliancePrefList = list;
            }

            /** 
             * Get the list of 'ExcludeAlliancePref' element items. Do not consider these alliances.
             * 
             * @return list
             */
            public List<AllianceType> getExcludeAlliancePrefList() {
                return excludeAlliancePrefList;
            }

            /** 
             * Set the list of 'ExcludeAlliancePref' element items. Do not consider these alliances.
             * 
             * @param list
             */
            public void setExcludeAlliancePrefList(List<AllianceType> list) {
                excludeAlliancePrefList = list;
            }
        }
    }
}
