
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Specifies carrier selection method.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApplicabilityEnumType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AllSegments"/>
 *     &lt;xs:enumeration value="AtLeastOneSegment"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ApplicabilityEnumType implements Serializable {
    ALL_SEGMENTS("AllSegments"), AT_LEAST_ONE_SEGMENT("AtLeastOneSegment");
    private final String value;

    private ApplicabilityEnumType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ApplicabilityEnumType convert(String value) {
        for (ApplicabilityEnumType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
