
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AvoidCabinDowngradeType">
 *   &lt;xs:attribute use="required" name="Mode">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Mode -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AvoidCabinDowngradeType implements Serializable
{
    private Mode mode;

    /** 
     * Get the 'Mode' attribute value. 
            Guarantees that lower cabin class won't be applied within single shopping option depending on the chosen mode:
            - All - Apply Avoid Cabin Downgrade logic on the entire itinerary
            - Main - Apply Avoid Cabin Downgrade logic on the main flight of every leg
            - None - Disable Avoid Cabin Downgrade logic (default value)
          
     * 
     * @return value
     */
    public Mode getMode() {
        return mode;
    }

    /** 
     * Set the 'Mode' attribute value. 
            Guarantees that lower cabin class won't be applied within single shopping option depending on the chosen mode:
            - All - Apply Avoid Cabin Downgrade logic on the entire itinerary
            - Main - Apply Avoid Cabin Downgrade logic on the main flight of every leg
            - None - Disable Avoid Cabin Downgrade logic (default value)
          
     * 
     * @param mode
     */
    public void setMode(Mode mode) {
        this.mode = mode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="All"/>
     *     &lt;xs:enumeration value="Main"/>
     *     &lt;xs:enumeration value="None"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Mode implements Serializable {
        ALL("All"), MAIN("Main"), NONE("None");
        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Mode convert(String value) {
            for (Mode inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
