
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information about baggage
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageInformationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Segment" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Segment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Allowance" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Allowance -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Charge" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Charge -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:BaggageProvisionType" use="required" name="ProvisionType"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="AirlineCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageInformationType implements Serializable
{
    private List<Segment> segmentList = new ArrayList<Segment>();
    private List<Allowance> allowanceList = new ArrayList<Allowance>();
    private List<Charge> chargeList = new ArrayList<Charge>();
    private BaggageProvisionType provisionType;
    private String airlineCode;

    /** 
     * Get the list of 'Segment' element items.
     * 
     * @return list
     */
    public List<Segment> getSegmentList() {
        return segmentList;
    }

    /** 
     * Set the list of 'Segment' element items.
     * 
     * @param list
     */
    public void setSegmentList(List<Segment> list) {
        segmentList = list;
    }

    /** 
     * Get the list of 'Allowance' element items.
     * 
     * @return list
     */
    public List<Allowance> getAllowanceList() {
        return allowanceList;
    }

    /** 
     * Set the list of 'Allowance' element items.
     * 
     * @param list
     */
    public void setAllowanceList(List<Allowance> list) {
        allowanceList = list;
    }

    /** 
     * Get the list of 'Charge' element items.
     * 
     * @return list
     */
    public List<Charge> getChargeList() {
        return chargeList;
    }

    /** 
     * Set the list of 'Charge' element items.
     * 
     * @param list
     */
    public void setChargeList(List<Charge> list) {
        chargeList = list;
    }

    /** 
     * Get the 'ProvisionType' attribute value. Provision Type (e.g. allowance, charges, embargo etc) (BPT)
     * 
     * @return value
     */
    public BaggageProvisionType getProvisionType() {
        return provisionType;
    }

    /** 
     * Set the 'ProvisionType' attribute value. Provision Type (e.g. allowance, charges, embargo etc) (BPT)
     * 
     * @param provisionType
     */
    public void setProvisionType(BaggageProvisionType provisionType) {
        this.provisionType = provisionType;
    }

    /** 
     * Get the 'AirlineCode' attribute value. Carrier whose baggage provisions apply (SFK)
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' attribute value. Carrier whose baggage provisions apply (SFK)
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:int" use="required" name="Id"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Segment implements Serializable
    {
        private Integer id;

        /** 
         * Get the 'Id' attribute value. Id of segment that current baggage information applies to.
         * 
         * @return value
         */
        public Integer getId() {
            return id;
        }

        /** 
         * Set the 'Id' attribute value. Id of segment that current baggage information applies to.
         * 
         * @param id
         */
        public void setId(Integer id) {
            this.id = id;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Allowance" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:int" use="optional" name="Pieces"/>
     *     &lt;xs:attribute type="xs:short" use="optional" name="Weight"/>
     *     &lt;xs:attribute type="ns:WeightUnitType" use="optional" name="Unit"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Description1"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Description2"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Allowance implements Serializable
    {
        private Integer pieces;
        private Short weight;
        private WeightUnitType unit;
        private String description1;
        private String description2;

        /** 
         * Get the 'Pieces' attribute value. Number of Pieces (BPC)
         * 
         * @return value
         */
        public Integer getPieces() {
            return pieces;
        }

        /** 
         * Set the 'Pieces' attribute value. Number of Pieces (BPC)
         * 
         * @param pieces
         */
        public void setPieces(Integer pieces) {
            this.pieces = pieces;
        }

        /** 
         * Get the 'Weight' attribute value. Weight Limit (B20)
         * 
         * @return value
         */
        public Short getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value. Weight Limit (B20)
         * 
         * @param weight
         */
        public void setWeight(Short weight) {
            this.weight = weight;
        }

        /** 
         * Get the 'Unit' attribute value. Units of the Weight Limit (N0D)
         * 
         * @return value
         */
        public WeightUnitType getUnit() {
            return unit;
        }

        /** 
         * Set the 'Unit' attribute value. Units of the Weight Limit (N0D)
         * 
         * @param unit
         */
        public void setUnit(WeightUnitType unit) {
            this.unit = unit;
        }

        /** 
         * Get the 'Description1' attribute value. Description 1 Text (D01)
         * 
         * @return value
         */
        public String getDescription1() {
            return description1;
        }

        /** 
         * Set the 'Description1' attribute value. Description 1 Text (D01)
         * 
         * @param description1
         */
        public void setDescription1(String description1) {
            this.description1 = description1;
        }

        /** 
         * Get the 'Description2' attribute value. Description 2 Text (D02)
         * 
         * @return value
         */
        public String getDescription2() {
            return description2;
        }

        /** 
         * Set the 'Description2' attribute value. Description 2 Text (D02)
         * 
         * @param description2
         */
        public void setDescription2(String description2) {
            this.description2 = description2;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Charge" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:float" use="optional" name="EquivalentAmount"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="EquivalentCurrency"/>
     *     &lt;xs:attribute type="xs:byte" use="optional" name="FirstPiece"/>
     *     &lt;xs:attribute type="xs:byte" use="optional" name="LastPiece"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Description1"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Description2"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="NoChargeNotAvailable"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Charge implements Serializable
    {
        private Float equivalentAmount;
        private String equivalentCurrency;
        private Byte firstPiece;
        private Byte lastPiece;
        private String description1;
        private String description2;
        private String noChargeNotAvailable;

        /** 
         * Get the 'EquivalentAmount' attribute value. Base Price (C52)
         * 
         * @return value
         */
        public Float getEquivalentAmount() {
            return equivalentAmount;
        }

        /** 
         * Set the 'EquivalentAmount' attribute value. Base Price (C52)
         * 
         * @param equivalentAmount
         */
        public void setEquivalentAmount(Float equivalentAmount) {
            this.equivalentAmount = equivalentAmount;
        }

        /** 
         * Get the 'EquivalentCurrency' attribute value. Currency Code (C5B)
         * 
         * @return value
         */
        public String getEquivalentCurrency() {
            return equivalentCurrency;
        }

        /** 
         * Set the 'EquivalentCurrency' attribute value. Currency Code (C5B)
         * 
         * @param equivalentCurrency
         */
        public void setEquivalentCurrency(String equivalentCurrency) {
            this.equivalentCurrency = equivalentCurrency;
        }

        /** 
         * Get the 'FirstPiece' attribute value. First Piece (OC1)
         * 
         * @return value
         */
        public Byte getFirstPiece() {
            return firstPiece;
        }

        /** 
         * Set the 'FirstPiece' attribute value. First Piece (OC1)
         * 
         * @param firstPiece
         */
        public void setFirstPiece(Byte firstPiece) {
            this.firstPiece = firstPiece;
        }

        /** 
         * Get the 'LastPiece' attribute value. Last Piece (OC2)
         * 
         * @return value
         */
        public Byte getLastPiece() {
            return lastPiece;
        }

        /** 
         * Set the 'LastPiece' attribute value. Last Piece (OC2)
         * 
         * @param lastPiece
         */
        public void setLastPiece(Byte lastPiece) {
            this.lastPiece = lastPiece;
        }

        /** 
         * Get the 'Description1' attribute value. Description 1 Text (D01)
         * 
         * @return value
         */
        public String getDescription1() {
            return description1;
        }

        /** 
         * Set the 'Description1' attribute value. Description 1 Text (D01)
         * 
         * @param description1
         */
        public void setDescription1(String description1) {
            this.description1 = description1;
        }

        /** 
         * Get the 'Description2' attribute value. Description 2 Text (D02)
         * 
         * @return value
         */
        public String getDescription2() {
            return description2;
        }

        /** 
         * Set the 'Description2' attribute value. Description 2 Text (D02)
         * 
         * @param description2
         */
        public void setDescription2(String description2) {
            this.description2 = description2;
        }

        /** 
         * Get the 'NoChargeNotAvailable' attribute value. 
                    No Charge Not Available (N43):
                    X - service not available.
                    F - no charge for service (free) and an EMD is not issued to reflect the free service.
                    E - no charge for service (free) and an EMD is issued to reflect the free service.
                    G - no charge for service (free), booking is not required and an EMD is not issued to reflect the free service.
                    H - no charge for service (free), booking is not required and an EMD is issued to reflect the free service.
                  
         * 
         * @return value
         */
        public String getNoChargeNotAvailable() {
            return noChargeNotAvailable;
        }

        /** 
         * Set the 'NoChargeNotAvailable' attribute value. 
                    No Charge Not Available (N43):
                    X - service not available.
                    F - no charge for service (free) and an EMD is not issued to reflect the free service.
                    E - no charge for service (free) and an EMD is issued to reflect the free service.
                    G - no charge for service (free), booking is not required and an EMD is not issued to reflect the free service.
                    H - no charge for service (free), booking is not required and an EMD is issued to reflect the free service.
                  
         * 
         * @param noChargeNotAvailable
         */
        public void setNoChargeNotAvailable(String noChargeNotAvailable) {
            this.noChargeNotAvailable = noChargeNotAvailable;
        }
    }
}
