
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * 
 A  - Checked Baggage Allowance,
 C  - Day of Check-in Charges,
 B  - Carry-on Baggage Allowance,
 CC - Carry-on Baggage Charges,
 E  - Baggage Embargo,
 P  - Prepaid Checked Baggage Charges,
 EE - Generic Embargo: No Excess Permitted

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageProvisionType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="A"/>
 *     &lt;xs:enumeration value="C"/>
 *     &lt;xs:enumeration value="B"/>
 *     &lt;xs:enumeration value="CC"/>
 *     &lt;xs:enumeration value="E"/>
 *     &lt;xs:enumeration value="P"/>
 *     &lt;xs:enumeration value="EE"/>
 *     &lt;xs:enumeration value=""/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BaggageProvisionType implements Serializable {
    A("A"), C("C"), B("B"), CC("CC"), E("E"), P("P"), EE("EE"), _("");
    private final String value;

    private BaggageProvisionType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BaggageProvisionType convert(String value) {
        for (BaggageProvisionType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
