
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 This describes beverage service in a given cabin. These alements are later referenced from FlightAmenities

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BeverageAmenityType">
 *   &lt;xs:attribute type="xs:integer" use="required" name="Id"/>
 *   &lt;xs:attribute type="ns:AmenityCostType" use="optional" name="AlcoholicCost"/>
 *   &lt;xs:attribute type="ns:AmenityCostType" use="optional" name="NonAlcoholicCost"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Exists"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BeverageAmenityType implements Serializable
{
    private BigInteger id;
    private AmenityCostType alcoholicCost;
    private AmenityCostType nonAlcoholicCost;
    private Boolean exists;

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public BigInteger getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(BigInteger id) {
        this.id = id;
    }

    /** 
     * Get the 'AlcoholicCost' attribute value.
     * 
     * @return value
     */
    public AmenityCostType getAlcoholicCost() {
        return alcoholicCost;
    }

    /** 
     * Set the 'AlcoholicCost' attribute value.
     * 
     * @param alcoholicCost
     */
    public void setAlcoholicCost(AmenityCostType alcoholicCost) {
        this.alcoholicCost = alcoholicCost;
    }

    /** 
     * Get the 'NonAlcoholicCost' attribute value.
     * 
     * @return value
     */
    public AmenityCostType getNonAlcoholicCost() {
        return nonAlcoholicCost;
    }

    /** 
     * Set the 'NonAlcoholicCost' attribute value.
     * 
     * @param nonAlcoholicCost
     */
    public void setNonAlcoholicCost(AmenityCostType nonAlcoholicCost) {
        this.nonAlcoholicCost = nonAlcoholicCost;
    }

    /** 
     * Get the 'Exists' attribute value.
     * 
     * @return value
     */
    public Boolean getExists() {
        return exists;
    }

    /** 
     * Set the 'Exists' attribute value.
     * 
     * @param exists
     */
    public void setExists(Boolean exists) {
        this.exists = exists;
    }
}
